﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;
using Mall.Common.Enum.Goods;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单介绍返佣仓储层
    /// </summary>
    public class RB_Goods_OrderIntroductionRepository : BaseRepository<RB_Goods_OrderIntroduction>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderIntroduction_Extend> GetList(RB_Goods_OrderIntroduction_Extend dmodel)
        {
            string where = $" 1=1 and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)} in({dmodel.OrderIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.IntroductionIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.Id)} in({dmodel.IntroductionIds})";
            }

            string sql = $@"SELECT oc.* FROM RB_Goods_OrderIntroduction oc
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
where {where} order by oc.Id asc";
            return Get<RB_Goods_OrderIntroduction_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderIntroduction_Extend> GetPageList(int pageIndex, int pageSize, out long count, RB_Goods_OrderIntroduction_Extend dmodel)
        {
            string where = $" 1=1 and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)} in({dmodel.OrderIds})";
            }
            if (dmodel.SupplierId > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.SupplierId)}={dmodel.SupplierId}";
            }
            if (dmodel.RemitStatus > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.RemitStatus)}={dmodel.RemitStatus}";
            }
            if (dmodel.CommissionState > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.CommissionState)}={dmodel.CommissionState}";
            }

            string sql = $@"SELECT oc.* FROM RB_Goods_OrderIntroduction oc
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
left join rb_goods_orderdetail od on oc.OrderDetailId= od.Id
where {where} order by oc.Id asc";
            return GetPage<RB_Goods_OrderIntroduction_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderIntroduction_Extend> GetListByNormal(RB_Goods_OrderIntroduction_Extend dmodel)
        {
            string where = $"  and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)} in({dmodel.OrderIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.IntroductionIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.Id)} in({dmodel.IntroductionIds})";
            }

            string sql = $@"SELECT oc.* FROM RB_Goods_OrderIntroduction oc
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
LEFT JOIN rb_goods_order go on oc.OrderId=go.OrderId   
where  go.OrderStatus in(1,2,3,4,5,6) and go.`Status`=0  {where}";
            return Get<RB_Goods_OrderIntroduction_Extend>(sql).ToList();
        }
        /// <summary>
        /// 获取用户返佣
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderIntroduction_Extend> GetOrderIntroductionPageList(int pageIndex, int pageSize, out long count, RB_Goods_OrderIntroduction_Extend dmodel)
        {
            string where = $" 1=1 and o.Recycled=2 and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.Type > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.Type)}={dmodel.Type}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.UserId)}={dmodel.UserId}";
            }

            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderCommission.OrderId)} in({dmodel.OrderIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderNo))
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderNo)}='{dmodel.OrderNo}'";
            }

            if (dmodel.SupplierId.HasValue && dmodel.SupplierId.Value > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.SupplierId)}={dmodel.SupplierId}";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and o.{nameof(RB_Goods.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and o.{nameof(RB_Goods.CreateDate)} <='{dmodel.EndTime + " 23:59:59"}'";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsName))
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.GoodsName)}='{dmodel.GoodsName}'";
            }
            if (dmodel.CommissionState > 0)
            {
                switch (dmodel.CommissionState)
                {
                    case 2: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}={(int)OrderStatusEnum.Completed}"; break;
                    case 1: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(2,3,4,6)"; break;
                    case 3: where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)}=1 "; break;
                }
            }
            else
            {
                where += $@" and o.{nameof(RB_Goods_Order.OrderStatus)} in(1,2,3,4,5,6)";
            }

            string sql = $@"SELECT GROUP_CONCAT(oc.OrderDetailId) as OrderDetailIds,oc.OrderId,oc.OrderDetailId,o.OrderNo,o.UserId,oc.CommissionRatio,oc.Type,oc.CommissionState,o.OrderStatus as DistrbutionOrderSelectStatus,SUM(oc.Commission) as Commission 
FROM RB_Goods_OrderIntroduction oc
inner join rb_goods_order o on oc.OrderId = o.OrderId
INNER JOIN rb_goods_orderdetail as od on od.Id=oc.OrderDetailId
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
where {where} group by oc.OrderId,o.OrderNo order by oc.OrderId desc";
            return GetPage<RB_Goods_OrderIntroduction_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }


    }
}
