﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.CacheManager.DataStatistic
{
    /// <summary>
    /// 数据常量
    /// </summary>
    public class DataConstant
    {
        /// <summary>
        /// 使用redis第几号库
        /// </summary>
        public static readonly int REDIS_DB = 1;

        /// <summary>
        /// 使用redis第几号库
        /// </summary>
        public static readonly int REDIS_DB2 = 2;

        #region 频道
        /// <summary>
        /// 数据变化通知频道
        /// </summary>
        public static readonly string DATA_CHANGE_NOTE_CHANNEL = "DATA_CHANGE_NOTE_CHANNEL";

        public static readonly string DATA_B2B_CHANGE_CHANNEL = "DATA_B2B_CHANGE_CHANNEL";
        #endregion

        #region redis 缓存键
        /// <summary>
        /// 数据统计缓存前缀
        /// </summary>
        public static readonly string CACHE_KEY_PREFIX = "DATA_STATISTIC_";

        /// <summary>
        /// b2b数据统计
        /// </summary>
        public static readonly string CACHE_KEY_B2BSTATISTIC = "DATA_B2B_STATISTIC";
        /// <summary>
        /// b2b登录城市
        /// </summary>
        public static readonly string CACHE_KEY_B2BCityHotSTATISTIC = "DATA_B2B_CityHot_STATISTIC";

        /// <summary>
        /// 任务队列
        /// </summary>
        public static readonly string CACHE_KEY_TASK_LIST = "TASK_LIST";

        /// <summary>
        /// 销售额
        /// </summary>
        public static readonly string CACHE_KEY_SALES = "SALES";

        /// <summary>
        /// 热词
        /// </summary>
        public static readonly string CACHE_KEY_HOT_WORD = "HOT_WORD";
        /// <summary>
        /// 广告
        /// </summary>
        public static readonly string CACHE_KEY_AD = "AD";
        #endregion
    }
}
