﻿using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using Mall.Repository;
using Mall.Repository.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.BaseSetUp
{
    /// <summary>
    /// 地区模块
    /// </summary>
    public class DestinationModule
    {
        private readonly Rb_destinationRepository rb_DestinationRepository = new Rb_destinationRepository();

        /// <summary>
        /// 根据父节点编号获取子列表
        /// </summary>
        /// <param name="ParentID">父节点编号</param>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetChildList(int ParentID)
        {
            RB_Destination_Extend where = new RB_Destination_Extend()
            {
                ParentID = ParentID
            };
            var list= rb_DestinationRepository.GetListExt(where);
          
            return list;
        }

        /// <summary>
        /// 根据父节点编号获取子列表
        /// </summary>
        /// <param name="ParentID">父节点编号</param>
        /// <returns></returns>
        public List<DestinationViewModel> GetChildListModule_V2(int ParentID)
        {
            List<DestinationViewModel> list = new List<DestinationViewModel>();
            var dataList = rb_DestinationRepository.GetAllDestinationList();
            if (dataList != null && dataList.Count > 0)
            {
                var tempList= dataList.Where(qitem => qitem.ParentID == ParentID)?.ToList();
                if (tempList != null && tempList.Count > 0)
                {
                    foreach (var item in tempList)
                    {
                        var model = new DestinationViewModel()
                        {
                            ID=item.ID,
                            Name=item.Name,
                            Children=new List<DestinationViewModel> ()
                        };
                        GetChildDestinationListModule(model,item.ID, dataList);
                        list.Add(model);
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 遍历下级地区
        /// </summary>
        /// <param name="currentModel"></param>
        /// <param name="sourceList"></param>
        private void GetChildDestinationListModule(DestinationViewModel currentModel,int ParentId,List<RB_Destination_Extend> sourceList)
        {
            if (sourceList != null && sourceList.Count > 0)
            {
                if (currentModel != null)
                {
                    var tempList = sourceList.Where(qitem => qitem.ParentID == ParentId)?.ToList();
                    if (tempList != null && tempList.Count > 0)
                    {
                        currentModel.Children = new List<DestinationViewModel>();
                        foreach (var item in tempList)
                        {
                            var cModel = new DestinationViewModel()
                            {
                                ID = item.ID,
                                Name = item.Name,
                                Children = new List<DestinationViewModel>()
                            };
                            GetChildDestinationListModule(cModel, item.ID, sourceList);
                            currentModel.Children.Add(cModel);
                        }
                    }
                }
            }
        }

        /// <summary>
        /// 根据地区名称获取地区列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Model.Extend.BaseSetUp.RB_Destination_Extend> GetDestinationListByNames(string[] where)
        {
            return rb_DestinationRepository.GetListByNames(where);
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetAllList()
        {
            return rb_DestinationRepository.GetAllDestinationList();
        }

        /// <summary>
        /// 获取中国下面的所有数据
        /// </summary>
        /// <returns></returns>
        public List<DestinationViewModel> GetAllListModule_V2()
        {
            List<DestinationViewModel> list = new List<DestinationViewModel>();
            var dataList= rb_DestinationRepository.GetAllDestinationList();
            if (dataList != null && dataList.Count > 0)
            {
               var templist = dataList.Where(qitem => qitem.ParentID == 1)?.ToList();
                if (templist != null && templist.Count > 0)
                {
                    foreach (var item in templist)
                    {
                        var model = new DestinationViewModel()
                        {
                            ID = item.ID,
                            Name = item.Name,
                            Children = new List<DestinationViewModel>()
                        };
                        GetChildDestinationListModule(model, item.ID, dataList);
                        list.Add(model);
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 新增修改地区
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Set(RB_Destination model)
        {
            bool flag;
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Destination.Name), model.Name},
                    {nameof(RB_Destination.EnName), model.EnName},
                    {nameof(RB_Destination.ParentID), model.ParentID},
                    {nameof(RB_Destination.CodeLevel), model.CodeLevel},
                    {nameof(RB_Destination.ThreeCode), model.ThreeCode},
                    {nameof(RB_Destination.FourCode), model.FourCode},
                    {nameof(RB_Destination.Images), model.Images},
                };
                if (model.Area != null && !string.IsNullOrEmpty(model.Area))
                {
                    fileds.Add(nameof(RB_Destination.Area), model.Area);
                }
                List<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper(){ FiledName=nameof(RB_Destination.ID),FiledValue=model.ID ,OperatorEnum=OperatorEnum.Equal}
                };
                flag = rb_DestinationRepository.Update(fileds, whereHelpers);
            }
            else
            {
                flag = rb_DestinationRepository.Insert(model) > 0;
            }
            return flag;
        }


        /// <summary>
        /// 更新地区拼音
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool UpdateDestinationPinYin(List<RB_Destination_Extend> list)
        {
            bool flag = false;
            foreach (var model in list)
            {
                if (model.ID > 0)
                {
                    Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Destination.PinYin), model.PinYin},

                };
                    List<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper(){ FiledName=nameof(RB_Destination.ID),FiledValue=model.ID ,OperatorEnum=OperatorEnum.Equal}
                };
                    flag = rb_DestinationRepository.Update(fileds, whereHelpers);
                }

            }
            return flag;
        }
    }
}
