﻿using Mall.Model.Entity.AppletWeChat;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.AppletWeChat
{
    public class RB_Live_HouseImgRepository : BaseRepository<RB_Live_HouseImg>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Live_HouseImg); } }

        /// <summary>
        /// 获取直播房间
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Live_HouseImg> GetLiveHouseListRepository(RB_Live_HouseImg query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Live_HouseImg.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Live_HouseImg.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.roomid))
                {
                    builder.Append($" AND {nameof(RB_Live_HouseImg.roomid)}='{query.roomid}'");
                }

            }
            return Get<RB_Live_HouseImg>(builder.ToString()).ToList();
        }

    }
}
