﻿using Mall.Common.Enum;
using Mall.Common.Enum.User;
using Mall.Model.Entity.Finance;
using Mall.Model.Extend.Finance;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Repository.Finance
{
    /// <summary>
    /// 费用类型仓储
    /// </summary>
    public partial class RB_CosttypeRepository : BaseRepository<RB_Costtype>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Costtype); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public List<RB_Costtype_Extend> GetList(RB_Costtype_Extend model)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND " + nameof(RB_Costtype.Status) + "={0} ", (int)DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND " + nameof(RB_Costtype.RB_Group_Id) + "={0} ", model.RB_Group_Id);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND " + nameof(RB_Costtype_Extend.Type) + " in({0},{1})", (int)model.Type, (int)Common.Enum.Finance.WFTempLateClassEnum.INAndOUT);
            }
            if (model.Tier > 0)
            {
                where += string.Format(" AND " + nameof(RB_Costtype.Tier) + "={0} ", model.Tier);
            }
            if (model.Is_Report >= 0)
            {
                where += string.Format(" AND " + nameof(RB_Costtype.Is_Report) + "={0} ", model.Is_Report);
            }
            if ((model.IsSecret??-1) >= 0)
            {
                where += string.Format(" AND " + nameof(RB_Costtype.IsSecret) + "={0} ", model.IsSecret);
            }
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += string.Format(" AND " + nameof(RB_Costtype.Name) + " like '%{0}%' ", model.Name);
            }
            return Get<RB_Costtype_Extend>("select * from " + TableName + where).ToList();
        }
        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="model"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Costtype_Extend> GetPageList(int pageIndex, int pageSize, RB_Costtype_Extend model, out long count)
        {
            string where = " WHERE 1=1 ";
            where += string.Format(" AND " + nameof(RB_Costtype_Extend.Status) + "={0}", (int)DateStateEnum.Normal);
            if (model.RB_Group_Id > 0)
            {
                where += string.Format(" AND " + nameof(RB_Costtype_Extend.RB_Group_Id) + "={0}", model.RB_Group_Id);
            }
            if (model.Type > 0)
            {
                where += string.Format(" AND " + nameof(RB_Costtype_Extend.Type) + "={0}", (int)model.Type);
            }
            if (model.ParentId > 0)
            {
                where += string.Format(" AND " + nameof(RB_Costtype_Extend.ParentId) + "={0}", model.ParentId);
            }
            if (model.Tier > 0)
            {
                where += string.Format(" AND " + nameof(RB_Costtype_Extend.Tier) + "={0}", model.Tier);
            }
            if (!string.IsNullOrEmpty(model.Name))
            {
                where += string.Format(" AND " + nameof(RB_Costtype_Extend.Name) + " like '%{0}%' ", model.Name);
            }
            return GetPage<RB_Costtype_Extend>(pageIndex, pageSize, out count, " select * from  " + TableName + where).ToList();
        }

    }
}
