﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 小程序页面仓储层
    /// </summary>
    public class RB_MiniProgram_PageRepository : BaseRepository<RB_MiniProgram_Page>
    {
        /// <summary>
        /// 根据查询条件获取小程序列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Page_Extend> GetListRepository(RB_MiniProgram_Page_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_MiniProgram_Page WHERE 1=1 ");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ",nameof(RB_MiniProgram_Page_Extend.MallBaseId),query.MallBaseId);
                }
            }
            return Get<RB_MiniProgram_Page_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取小程序分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_MiniProgram_Page_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_MiniProgram_Page_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_MiniProgram_Page WHERE 1=1 ");
            if (query != null)
            {
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_MiniProgram_Page_Extend.MallBaseId), query.MallBaseId);
                }
            }
            return GetPage<RB_MiniProgram_Page_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 根据Id批量删除
        /// </summary>
        /// <param name="Ids"></param>
        /// <returns></returns>
        public bool RemoveBeatchMiniprogram_Page_Repository(string Ids)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(" DELETE  FROM RB_MiniProgram_Page WHERE Id IN ({0}) ", Ids);
            return base.Execute(builder.ToString()) > 0;
        }
    }
}
