﻿using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using Mall.Common.API;
using Mall.Common.Enum;
using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Resources;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Threading.Tasks;
using System.Web;

namespace Mall.Common
{

    /// <summary>
    /// 全局配置
    /// </summary>
    public class Config
    {

        private static readonly byte[] _webapikey = { 0xF1, 0x12, 0xA3, 0xD1, 0xBA, 0x54, 0x2A, 0x88 };
        private static readonly byte[] _webapiiv = { 0x04, 0xAE, 0x57, 0x83, 0x56, 0x28, 0x66, 0xA7 };


        /// <summary>
        /// WebApiKey
        /// </summary>
        static public byte[] WebApiKey
        {
            get { return _webapikey; }
        }
        /// <summary>
        /// WebService接口加密IV
        /// </summary>
        static public byte[] WebApiIV
        {
            get { return _webapiiv; }
        }

        /// <summary>
        /// 超级管理员id
        /// </summary>
        /// <returns></returns>
        public static string AdminId
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("AdminId").Value;
            }
        }

        /// <summary>
        /// 异常日志保存路径
        /// </summary>
        public static string LogPath
        {
            get
            {
                string logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log/error");
                return logPath.ToString();
            }
        }

        /// <summary>
        /// 打印日志保存路径
        /// </summary>
        public static string InofLogPath
        {
            get
            {
                string logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log/info");
                return logPath.ToString();
            }
        }

        /// <summary>
        /// 接口请求日志保存路径
        /// </summary>
        public static string RequestLogPath
        {
            get
            {
                string logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log/request");
                return logPath.ToString();
            }
        }

        /// <summary>
        /// JWT加密秘钥
        /// </summary>
        public static string JwtSecretKey
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("JwtSecretKey").Value;
            }
        }

        /// <summary>
        /// 过期时间，单位为秒
        /// </summary>
        public static int JwtExpirTime
        {
            get
            {
                return Convert.ToInt32(new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("JwtExpirTime").Value);
            }
        }
        /// <summary>
        /// 接口请求过期时间，单位为秒
        /// </summary>
        public static int ApiExpirTime
        {
            get
            {
                return Convert.ToInt32(new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("ApiExpirTime").Value);
            }
        }



        /// <summary>
        /// 读取配置文件key的值
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        private static string ReadConfigKey(string key)
        {
            try
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection(key).Value;
            }
            catch
            {
                return "";
            }
        }

        /// <summary>
        /// 阿里云oss域名
        /// </summary>
        public static string GetOssFileUrl
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("ViewFileSiteUrl").Value;
            }
        }

        /// <summary>
        /// 获取Oss文件全路径
        /// </summary>
        /// <param name="path">文件相对路径</param>
        /// <returns></returns>
        public static string GetFileUrl(string path)
        {
            if (string.IsNullOrWhiteSpace(path))
            {
                return null;
            }
            else
            {
                string p = @"(http|https)://(?<domain>[^(:|/]*)";
                Regex reg = new Regex(p, RegexOptions.IgnoreCase);
                string value = reg.Match(path).Value;
                if (!string.IsNullOrEmpty(value))
                {
                    return path;
                }
                else
                {
                    return GetOssFileUrl + path;
                }
            }
        }


        /// <summary>
        /// 获取文件相对路径
        /// </summary>
        public static string GetFilePath(string path)
        {
            if (!string.IsNullOrWhiteSpace(path))
            {
                string p = @"(http|https)://(?<domain>[^(:|/]*)";
                Regex reg = new Regex(p, RegexOptions.IgnoreCase);
                string value = reg.Match(path).Value;
                if (!string.IsNullOrEmpty(value))
                {
                    Uri url = new Uri(path);
                    return url.AbsolutePath;
                }
                else
                {
                    return path;
                }

            }
            else
            {
                return path;
            }

        }

        public static string FileService
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("FileService").Value;
            }
        }


        /// <summary>
        /// 上传站点地址
        /// </summary>

        public static string UploadSiteUrl
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("UploadSiteUrl").Value;
            }
        }


        /// <summary>
        /// 上传文件预览站点
        /// </summary>
        public static string ViewFileSiteUrl
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("ViewFileSiteUrl").Value;
            }
        }

        /// <summary>
        /// 导出文件保存路径
        /// </summary>
        public static string FileExportPath
        {
            get
            {
                string fileExportPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "ExportFile");
                if (!Directory.Exists(fileExportPath))
                {
                    Directory.CreateDirectory(fileExportPath);
                }
                return fileExportPath;
            }
        }

        public static string VirtualDirectory
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("VirtualDirectory").Value;
            }
        }


        public static string Mongo
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("Mongo").Value;
            }
        }
        public static string MongoDBName
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("MongoDBName").Value;
            }
        }

        /// <summary>
        /// 小程序发布程序路径
        /// </summary>
        public static string ProjectUrl
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("ProjectUrl").Value;
            }
        }

        /// <summary>
        /// 小程序开发工具端口号
        /// </summary>
        public static string DeveloperKitsPort
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("DeveloperKitsPort").Value;
            }
        }
        /// <summary>
        /// 小程序生成二维码跳转地址
        /// </summary>
        public static string FirstPage
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("FirstPage").Value;
            }
        }


        /// <summary>
        /// 抖音发送消息模板
        /// </summary>
        public static string ByteDanceSendTemplate
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("ByteDanceSendTemplate").Value;
            }
        }

        /// <summary>
        /// 微信支付成功接口处理地址
        /// </summary>
        public static string sTenpayNotify
        {
            get
            {
                return new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("sTenpayNotify").Value;
            }
        }



    }
}