﻿using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Extend.BaseSetUp;
using Mall.Repository;
using Mall.Repository.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Module.BaseSetUp
{
    /// <summary>
    /// 地区模块
    /// </summary>
    public class DestinationModule
    {
        private Rb_destinationRepository rb_DestinationRepository = new Rb_destinationRepository();


        /// <summary>
        /// 获取地区分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="where"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetPageList(int pageIndex, int pageSize, RB_Destination_Extend where, out long count)
        {
            return rb_DestinationRepository.GetPageList(pageIndex, pageSize, where, out count);
        }

        /// <summary>
        /// 根据洲获取国家
        /// </summary>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetCountryByArea(string Area)
        {
            RB_Destination_Extend where = new RB_Destination_Extend()
            {
                QArea = Area,
                CodeLevel = Common.Enum.AreaRegionEnum.CountryEnum
            };
            return rb_DestinationRepository.GetListExt(where);
        }

        /// <summary>
        /// 获取国家
        /// </summary>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetCountry()
        {
            RB_Destination_Extend where = new RB_Destination_Extend()
            {
                CodeLevel = Common.Enum.AreaRegionEnum.CountryEnum
            };
            return rb_DestinationRepository.GetListExt(where);
        }

        /// <summary>
        /// 根据条件获取单个地区
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public RB_Destination_Extend GetEntityExt(RB_Destination_Extend where)
        {
            return rb_DestinationRepository.GetEntityExt(where);
        }

        /// <summary>
        /// 根据地区名称获取地区列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetListByNames(string[] where)
        {
            return rb_DestinationRepository.GetListByNames(where);
        }

        /// <summary>
        /// 获取实体
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public RB_Destination GetEntity(object id)
        {
            return rb_DestinationRepository.GetEntity(id);
        }

        /// <summary>
        /// 根据父节点编号获取子列表
        /// </summary>
        /// <param name="ParentID">父节点编号</param>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetChildList(int ParentID)
        {
            RB_Destination_Extend where = new RB_Destination_Extend()
            {
                ParentID = ParentID
            };
            return rb_DestinationRepository.GetListExt(where);
        }

        /// <summary>
        /// 获取所有的地区数据
        /// </summary>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetListByCountryId(RB_Destination_Extend where)
        {
            return rb_DestinationRepository.GetListByCountryId(where);
        }

        /// <summary>
        /// 获取城市列表
        /// </summary>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetCityList()
        {
            RB_Destination_Extend where = new RB_Destination_Extend()
            {
                CodeLevel = Common.Enum.AreaRegionEnum.CityEnum
            };
            return rb_DestinationRepository.GetListExt(where);
        }

        /// <summary>
        /// 根据查询条件获取
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Destination_Extend> GetListModule(RB_Destination_Extend where)
        {
            return rb_DestinationRepository.GetListExt(where);
        }

        /// <summary>
        /// 获取省份和城市列表
        /// </summary>
        /// <param name="isGetArea">是否查询区县</param>
        /// <returns></returns>
        public object GetProviceAndCityList(bool isGetArea = false)
        {
            var CommonList = Mall.Common.Data.AreaDataHelper.GetAreaList();
            if (CommonList != null && CommonList.Count > 0)
            {
                if (isGetArea)
                {
                    return CommonList.Where(qitem => (qitem.L == 3 || qitem.L == 2 || qitem.L == 4) && qitem.P != 2).Select(qitem => new { ID = qitem.I, Name = qitem.N });

                }
                else
                {
                    return CommonList.Where(qitem => (qitem.L == 3 || qitem.L == 2) && qitem.P != 2).Select(qitem => new { ID = qitem.I, Name = qitem.N });
                }
            }
            var list = rb_DestinationRepository.GetProviceAndCityList(isGetArea: isGetArea);
            return list.Select(item => new { item.ID, item.Name });
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <returns></returns>
        public List<Mall.Common.Data.Node> GetAllList()
        {
            return rb_DestinationRepository.GetAllList();
        }

        /// <summary>
        /// 新增修改地区
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool Set(RB_Destination model)
        {
            var flag = false;
            if (model.ID > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Destination.Name), model.Name},
                    {nameof(RB_Destination.EnName), model.EnName},
                    {nameof(RB_Destination.ParentID), model.ParentID},
                    {nameof(RB_Destination.CodeLevel), model.CodeLevel},
                    {nameof(RB_Destination.ThreeCode), model.ThreeCode},
                    {nameof(RB_Destination.FourCode), model.FourCode},
                    {nameof(RB_Destination.Images), model.Images},
                };
                if (model.Area != null && !string.IsNullOrEmpty(model.Area))
                {
                    fileds.Add(nameof(RB_Destination.Area), model.Area);
                }
                List<WhereHelper> whereHelpers = new List<WhereHelper>()
                {
                    new WhereHelper(){ FiledName=nameof(RB_Destination.ID),FiledValue=model.ID ,OperatorEnum=OperatorEnum.Equal}
                };
                flag = rb_DestinationRepository.Update(fileds, whereHelpers);
            }
            else
            {
                flag = rb_DestinationRepository.Insert(model) > 0;
            }
            return flag;
        }

        /// <summary>
        /// 删除数据
        /// </summary>
        /// <param name="ID"></param>
        /// <returns></returns>
        public bool Remove(RB_Destination model)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                { nameof(RB_Destination_Extend.Status),(int)Common.Enum.DateStateEnum.Delete}
            };
            var flag = true;
            var trans = rb_DestinationRepository.DbTransaction;
            try
            {
                //省
                List<RB_Destination_Extend> ProvinceList = new List<RB_Destination_Extend>();
                //城市
                List<RB_Destination_Extend> CityList = new List<RB_Destination_Extend>();
                //区县
                List<RB_Destination_Extend> DistrictList = new List<RB_Destination_Extend>();
                switch (model.CodeLevel)
                {
                    //删除国家及国家下面的所有数据
                    case Common.Enum.AreaRegionEnum.CountryEnum:
                        ProvinceList = this.GetChildList(model.ID);
                        foreach (var item in ProvinceList)
                        {
                            CityList = this.GetChildList(item.ID);
                            foreach (var subItem in DistrictList)
                            {
                                DistrictList = this.GetChildList(subItem.ID);
                                foreach (var thirdItem in DistrictList)
                                {
                                    //删除区县
                                    rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), thirdItem.ID), trans);
                                }
                                //删除城市
                                rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), subItem.ID), trans);
                            }
                            //删除省
                            rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), item.ID), trans);
                        }
                        //删除国家
                        rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), model.ID), trans);
                        break;
                    //删除省及省下面的市、区县
                    case Common.Enum.AreaRegionEnum.ProvinceEnum:

                        CityList = this.GetChildList(model.ID);
                        foreach (var item in DistrictList)
                        {
                            DistrictList = this.GetChildList(item.ID);
                            foreach (var subItem in DistrictList)
                            {
                                //删除区县
                                rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), subItem.ID), trans);
                            }
                            //删除城市
                            rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), item.ID), trans);
                        }

                        //删除省
                        rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), model.ID), trans);

                        break;
                    //删除城市及下面的区县
                    case Common.Enum.AreaRegionEnum.CityEnum:

                        DistrictList = this.GetChildList(model.ID);
                        foreach (var item in DistrictList)
                        {
                            //删除区县
                            rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), item.ID), trans);
                        }
                        //删除城市
                        rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), model.ID), trans);
                        break;
                    //删除区县
                    case Common.Enum.AreaRegionEnum.DistrictEnum:
                        rb_DestinationRepository.Update(fileds, new WhereHelper(nameof(RB_Destination_Extend.ID), model.ID), trans);
                        break;
                }

                rb_DestinationRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "Remove");
                rb_DestinationRepository.DBSession.Rollback("Remove");
                flag = false;
            }
            return flag;
        }

        /// <summary>
        /// 判断是否存在
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public bool IsExists(RB_Destination where)
        {
            IList<WhereHelper> whereHelpers = new List<WhereHelper>()
            {
                 new  WhereHelper(){  FiledName=nameof(RB_Destination.Name), FiledValue=where.Name.Trim(), OperatorEnum= OperatorEnum.Equal},
                 new  WhereHelper(){  FiledName=nameof(RB_Destination.Status), FiledValue=(int)Common.Enum.DateStateEnum.Normal, OperatorEnum= OperatorEnum.Equal},
                 new  WhereHelper(){  FiledName=nameof(RB_Destination.CodeLevel), FiledValue=where.CodeLevel, OperatorEnum= OperatorEnum.Equal},
            };
            //地区，验证城市下面的区不重复
            if (where.CodeLevel == Common.Enum.AreaRegionEnum.DistrictEnum)
            {
                whereHelpers.Add(new WhereHelper(nameof(RB_Destination.ParentID), where.ParentID));
            }
            if (where.ID > 0)
            {
                whereHelpers.Add(new WhereHelper()
                {
                    FiledName = nameof(RB_Destination.ID),
                    FiledValue = where.ID,
                    OperatorEnum = OperatorEnum.NotEqual
                });
            }
            return rb_DestinationRepository.Exists(whereHelpers);
        }
    }
}
