﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品仓储层
    /// </summary>
    public class RB_GoodsRepository : RepositoryBase<RB_Goods>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Goods_Extend dmodel)
        {
            string where = $" 1=1 and g.{nameof(RB_Goods_Extend.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and g.{nameof(RB_Goods_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and g.{nameof(RB_Goods_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds)) {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name)) {
                where += $@" and g.{nameof(RB_Goods_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.GoodsStatus > 0) {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsStatus)}={dmodel.GoodsStatus}";
            }
            if (dmodel.IsSelectSellOut == 1) {
                where += $@" and g.{nameof(RB_Goods_Extend.InventoryNum)}<=0";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIds)) {
                where += $@" and c.{nameof(RB_Goods_Category.CategoryId)} in({dmodel.CategoryIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime)) {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime)) {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} <='{dmodel.EndTime + " 23:59:59"}'";
            }
            
            string sql = $@"select g.* from RB_Goods g
inner join rb_goods_category c on g.Id=c.GoodsId 
where {where} group by g.Id order by g.CreateDate desc";
            return GetPage<RB_Goods_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetList(RB_Goods_Extend dmodel)
        {
            string where = $" 1=1 and g.{nameof(RB_Goods_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.GoodsStatus > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsStatus)}={dmodel.GoodsStatus}";
            }
            if (dmodel.IsSelectSellOut == 1)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.InventoryNum)}<=0";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIds))
            {
                where += $@" and c.{nameof(RB_Goods_Category.CategoryId)} in({dmodel.CategoryIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} <='{dmodel.EndTime + " 23:59:59"}'";
            }

            string sql = $@"select g.* from RB_Goods g
inner join rb_goods_category c on g.Id=c.GoodsId 
where {where} group by g.Id order by g.CreateDate desc";
            return Get<RB_Goods_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetSingleList(RB_Goods_Extend dmodel)
        {
            string where = $" 1=1 and g.{nameof(RB_Goods_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsNameStr)) 
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Name)} in ({dmodel.GoodsNameStr})";
            }
            if (dmodel.GoodsStatus > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsStatus)}={dmodel.GoodsStatus}";
            }
            if (dmodel.IsSelectSellOut == 1)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.InventoryNum)}<=0";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} <='{dmodel.EndTime + " 23:59:59"}'";
            }

            string sql = $@"select g.* from RB_Goods g where {where}";
            return Get<RB_Goods_Extend>(sql).ToList();
        }

        /// <summary>
        /// 小程序获取商品列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetAppletGoodsPageList(int pageIndex, int pageSize, out long count, RB_Goods_Extend dmodel)
        {
            string where = $" 1=1 and g.{nameof(RB_Goods_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.GoodsStatus > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsStatus)}={dmodel.GoodsStatus}";
            }
            if (dmodel.GoodsType > 0) 
            {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsType)}={dmodel.GoodsType}";
            }
            if (dmodel.IsSelectSellOut == 1)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.InventoryNum)}<=0";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIds))
            {
                where += $@" and c.{nameof(RB_Goods_Category.CategoryId)} in({dmodel.CategoryIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} <='{dmodel.EndTime + " 23:59:59"}'";
            }
            string orderBy = $" order by g.{nameof(RB_Goods_Extend.Sort)} asc";
            if (dmodel.OrderBy == 1)
            {//最新
                orderBy = $" order by g.{nameof(RB_Goods_Extend.CreateDate)} desc";
            }
            else if (dmodel.OrderBy == 2)
            {
                //价格低-高
                orderBy = $" order by g.{nameof(RB_Goods_Extend.SellingPrice)} asc";
            }
            else if (dmodel.OrderBy == 3)
            {
                //价格高-低
                orderBy = $" order by g.{nameof(RB_Goods_Extend.SellingPrice)} desc";
            }
            else if (dmodel.OrderBy == 4) {
                //销量高-低
                orderBy = $" order by g.{nameof(RB_Goods_Extend.SalesNum)} desc";
            }
            if (dmodel.IsSelectVideo == 1) {
                where += $@" and g.{nameof(RB_Goods_Extend.VideoAddress)} !=''";
            }
            if (dmodel.GoodsId > 0)
            {
                if (dmodel.SelectVideoDirection == 1)
                {
                    where += $@" and g.{nameof(RB_Goods_Extend.Id)}>={dmodel.Id}";
                    orderBy = $" order by g.{nameof(RB_Goods_Extend.Id)} asc";
                }
                else
                {
                    where += $@" and g.{nameof(RB_Goods_Extend.Id)}<={dmodel.Id}";
                    orderBy = $" order by g.{nameof(RB_Goods_Extend.Id)} desc";
                }
            }

            string sql = $@"select g.* from RB_Goods g
inner join rb_goods_category c on g.Id=c.GoodsId 
where {where} group by g.Id {orderBy}";
            return GetPage<RB_Goods_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

        /// <summary>
        /// 获取会员收藏商品分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetMemberCollectGoodsPageList(int pageIndex, int pageSize, out long rowCount, RB_Goods_Extend dmodel)
        {
            string where = $" 1=1 and col.{nameof(RB_Goods_Extend.Status)}=0";
            where += $" and col.Type=1 and col.UserId={dmodel.UserId} and g.{nameof(RB_Goods_Extend.Status)}=0 and g.{nameof(RB_Goods_Extend.GoodsStatus)}=1";
            if (dmodel.TenantId > 0)
            {
                where += $@" and col.{nameof(RB_Goods_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and col.{nameof(RB_Goods_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)}={dmodel.Id}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)} in({dmodel.GoodsIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Name)} like '%{dmodel.Name}%'";
            }
            if (dmodel.GoodsStatus > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsStatus)}={dmodel.GoodsStatus}";
            }
            if (dmodel.IsSelectSellOut == 1)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.InventoryNum)}<=0";
            }
            if (!string.IsNullOrEmpty(dmodel.CategoryIds))
            {
                where += $@" and c.{nameof(RB_Goods_Category.CategoryId)} in({dmodel.CategoryIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.CreateDate)} <='{dmodel.EndTime + " 23:59:59"}'";
            }

            string sql = $@"select g.* from 
rb_member_collection col
inner join RB_Goods g on col.GoodsId=g.Id
inner join rb_goods_category c on g.Id=c.GoodsId 
where {where} group by g.Id order by col.Id desc";
            return GetPage<RB_Goods_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        public List<RB_Goods_Extend> GetGoodsInventoryNumList(RB_Goods_Extend dmodel)
        {
            string where = $" 1=1 and g.{nameof(RB_Goods_Extend.Status)}=0";
            if (dmodel.TenantId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and g.{nameof(RB_Goods_Extend.Id)} in({dmodel.GoodsIds})";
            }
            if (dmodel.GoodsStatus > 0)
            {
                where += $@" and g.{nameof(RB_Goods_Extend.GoodsStatus)}={dmodel.GoodsStatus}";
            }

            string sql = $@"select g.Id,g. from RB_Goods g where {where} group by g.Id asc";
            return Get<RB_Goods_Extend>(sql).ToList();
        }
    }
}
