﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 会员足迹仓储层
    /// </summary>
    public class RB_Member_FootmarkRepository : RepositoryBase<RB_Member_Footmark>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Footmark_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Member_Footmark_Extend dmodel)
        {
            string where = $" 1=1 and g.Status=0 and g.GoodsStatus=1 and f.{nameof(RB_Member_Footmark.Status)}=0 ";
            if (dmodel.TenantId > 0) {
                where += $@" and f.{nameof(RB_Member_Footmark.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and f.{nameof(RB_Member_Footmark.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0) {
                where += $@" and f.{nameof(RB_Member_Footmark.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.GoodsId > 0) {
                where += $@" and f.{nameof(RB_Member_Footmark.GoodsId)} ={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime)) {
                where += $@" and f.{nameof(RB_Member_Footmark.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime)) {
                where += $@" and f.{nameof(RB_Member_Footmark.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }

            string sql = $@"select f.* from RB_Member_Footmark f
inner join rb_goods g on f.GoodsId = g.Id
where {where} order by f.CreateDate desc";
            return GetPage<RB_Member_Footmark_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_Footmark_Extend> GetList(RB_Member_Footmark_Extend dmodel)
        {
            string where = $" 1=1 and {nameof(RB_Member_Footmark.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Member_Footmark.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Member_Footmark.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and {nameof(RB_Member_Footmark.UserId)} ={dmodel.UserId}";
            }
            if (dmodel.GoodsId > 0)
            {
                where += $@" and {nameof(RB_Member_Footmark.GoodsId)} ={dmodel.GoodsId}";
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime))
            {
                where += $@" and {nameof(RB_Member_Footmark.CreateDate)} >='{dmodel.StartTime}'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += $@" and {nameof(RB_Member_Footmark.CreateDate)} <='{dmodel.EndTime} 23:59:59'";
            }

            string sql = $@"select * from RB_Member_Footmark where {where} order by CreateDate desc";
            return Get<RB_Member_Footmark_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取我的收藏
        /// </summary>
        /// <param name="UserId"></param>
        /// <param name="TenantId"></param>
        /// <param name="MallBaseId"></param>
        /// <returns></returns>
        public int GetMyFootmarkNum(int UserId, int TenantId, int MallBaseId)
        {
            string where = $" 1=1 and g.Status=0 and g.GoodsStatus=1 and f.{nameof(RB_Member_Footmark.Status)}=0 ";
            if (TenantId > 0)
            {
                where += $@" and f.{nameof(RB_Member_Footmark.TenantId)}={TenantId}";
            }
            if (MallBaseId > 0)
            {
                where += $@" and f.{nameof(RB_Member_Footmark.MallBaseId)}={MallBaseId}";
            }
            if (UserId > 0)
            {
                where += $@" and f.{nameof(RB_Member_Footmark.UserId)} ={UserId}";
            }

            string sql = $@"select count(0) from RB_Member_Footmark f
inner join rb_goods g on f.GoodsId = g.Id
where {where} order by f.CreateDate desc";
            var obj = ExecuteScalar(sql);
            if (obj != null)
            {
                return Convert.ToInt32(obj);
            }
            else {
                return 0;
            }
        }
    }
}
