﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 供应商
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Supplier
    {
        public int ID { get; set; }

        /// <summary>
        /// 供应商名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// 联系电话
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 银行账户信息
        /// </summary>
        public int BankAccountId { get; set; }

        /// <summary>
        /// 供应商状态0-正常，1-禁用
        /// </summary>
        public int SupplierStatus { get; set; }


        /// <summary>
        /// 供应商关联人
        /// </summary>
        public int Introducer { get; set; }


        /// <summary>
        /// 供应商关联人返佣比例
        /// </summary>
        public decimal CommissionRate { get; set; }
    }
}
