﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Linq;
using Mall.Model.Entity.User;
using Mall.Common.Enum.Goods;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品订单介绍返佣仓储层
    /// </summary>
    public class RB_Goods_OrderIntroductionRepository : RepositoryBase<RB_Goods_OrderIntroduction>
    {

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderIntroduction_Extend> GetList(RB_Goods_OrderIntroduction_Extend dmodel)
        {
            string where = $" 1=1 and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)} in({dmodel.OrderIds})";
            }
            if (!string.IsNullOrEmpty(dmodel.IntroductionIds)) {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.Id)} in({dmodel.IntroductionIds})";
            }

            string sql = $@"SELECT oc.* FROM RB_Goods_OrderIntroduction oc
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
where {where} order by oc.Id asc";
            return Get<RB_Goods_OrderIntroduction_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Goods_OrderIntroduction_Extend> GetPageList(int pageIndex,int pageSize,out long count,RB_Goods_OrderIntroduction_Extend dmodel)
        {
            string where = $" 1=1 and oa.ReOrderId is null";
            if (dmodel.TenantId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.OrderId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)}={dmodel.OrderId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.UserId)}={dmodel.UserId}";
            }
            if (!string.IsNullOrEmpty(dmodel.OrderIds))
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.OrderId)} in({dmodel.OrderIds})";
            }
            if (dmodel.SupplierId > 0)
            {
                where += $@" and od.{nameof(RB_Goods_OrderDetail.SupplierId)}={dmodel.SupplierId}";
            }
            if (dmodel.RemitStatus > 0) {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.RemitStatus)}={dmodel.RemitStatus}";
            }
            if (dmodel.CommissionState > 0) 
            {
                where += $@" and oc.{nameof(RB_Goods_OrderIntroduction.CommissionState)}={dmodel.CommissionState}";
            }

            string sql = $@"SELECT oc.* FROM RB_Goods_OrderIntroduction oc
left join rb_goods_orderaftersale oa on oc.OrderDetailId= oa.OrderDetialId and oa.Type=1 and oa.Status=0 and oa.ReOrderStatus in (2,3,4,5)
left join rb_goods_orderdetail od on oc.OrderDetailId= od.Id
where {where} order by oc.Id asc";
            return GetPage<RB_Goods_OrderIntroduction_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

    }
}
