﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品订单介绍返佣表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderIntroduction_Extend : RB_Goods_OrderIntroduction
    {
        /// <summary>
        /// ids
        /// </summary>
        public string OrderIds { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }
        /// <summary>
        /// 姓名
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 手机号码
        /// </summary>
        public string Mobile { get; set; }
        /// <summary>
        /// 用户头像
        /// </summary>
        public string Photo { get; set; }
        /// <summary>
        /// 分销订单查询状态  0全部  1代付款  2已付款  3已完成
        /// </summary>
        public int? DistrbutionOrderSelectStatus { get; set; }
        /// <summary>
        /// 订单明细列表
        /// </summary>
        public List<RB_Goods_OrderDetail_Extend> OrderDetailList { get; set; }
        /// <summary>
        /// 待返佣金额
        /// </summary>
        public decimal WaitCommission { get; set; }
        /// <summary>
        /// 供应商id
        /// </summary>
        public int? SupplierId { get; set; }
        /// <summary>
        /// 返佣ids
        /// </summary>
        public string IntroductionIds { get; set; }
    }
}
