using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text.Encodings.Web;
using System.Text.Unicode;
using System.Threading.Tasks;
using Dnc.Api.Throttle;
using Mall.CacheManager.User;
using Mall.Module.Education;
using Mall.ThirdCore.Message;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Options;
using Senparc.CO2NET;
using Senparc.CO2NET.RegisterServices;
using Senparc.Weixin;
using Senparc.Weixin.Entities;
using Senparc.Weixin.RegisterServices;

namespace Mall.WebApi
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        /// <summary>
        /// This method gets called by the runtime. Use this method to add services to the container.
        /// </summary>
        /// <param name="services"></param>
        public void ConfigureServices(IServiceCollection services)
        {
            services.Configure<Microsoft.AspNetCore.Server.Kestrel.Core.KestrelServerOptions>(x => x.AllowSynchronousIO = true)
                .Configure<IISServerOptions>(x => x.AllowSynchronousIO = true);
            services.AddControllers();
            services.AddSingleton<IHttpContextAccessor, HttpContextAccessor>(); //עhttp
      
            services.AddSenparcGlobalServices(Configuration)//Senparc.CO2NET ȫע
                     .AddSenparcWeixinServices(Configuration);//Senparc.Weixin ע
            services.AddMvc().AddJsonOptions(options =>
            {
                options.JsonSerializerOptions.Encoder = JavaScriptEncoder.Create(UnicodeRanges.All);
                options.JsonSerializerOptions.PropertyNamingPolicy = null;
            });
            List<string> corsArray = new List<string>()
            {
                "http://localhost:8081",
                "http://localhost:8181",
                "http://localhost:8080",
                "http://localhost:8082",
                "http://localhost:8083",
                "http://127.0.0.1:50512",
                "http://127.0.0.1:20224",
                "http://127.0.0.1:28221",
                "http://www.test.com:8080",
                "http://www.test.com:8081",
                "http://yx.oytour.com",
                "http://mall.oytour.com",
                "http://testmall.oytour.com",
                "http://yx.oytour.com",
                "https://mallapi.oytour.com",
                "http://edu.oytour.com"
            };
            services.AddCors(options => options.AddPolicy("AllowCors", policy => policy.AllowAnyHeader().AllowAnyMethod().AllowCredentials().WithOrigins(corsArray.ToArray())));

            services.Configure<ForwardedHeadersOptions>(options =>
            {
                options.ForwardedHeaders = Microsoft.AspNetCore.HttpOverrides.ForwardedHeaders.XForwardedFor
                | Microsoft.AspNetCore.HttpOverrides.ForwardedHeaders.XForwardedProto;
                options.KnownProxies.Add(IPAddress.Parse("47.96.12.235"));
            });

            //Api
            services.AddApiThrottle(options => {
                //redis
                options.UseRedisCacheAndStorage(opts => {
                    opts.ConnectionString = "47.96.23.199,password=Viitto2018,connectTimeout=5000,allowAdmin=false,defaultDatabase=0";
                    opts.KeyPrefix = "apithrottle"; //ָkeyǰ׺ĬΪapithrottle
                });
            });

            //ApiThrottleActionFilter
            services.AddMvc(opts => {
                opts.Filters.Add(typeof(ApiThrottleActionFilter));

            }).SetCompatibilityVersion(CompatibilityVersion.Version_3_0);

            services.AddApiThrottle(options =>
            {
                options.Global.AddValves(
                    new BlackListValve
                    {
                        Policy = Policy.Ip,
                        Priority = 99
                    },
                    new WhiteListValve
                    {
                        Policy = Policy.UserIdentity,
                        Priority = 88
                    },
                    new BlackListValve
                    {
                        Policy = Policy.Header,
                        PolicyKey = "throttle",
                    }
                );
                options.OnIpAddress = (context) =>
                {
                    string ip = context.Request.Headers["X-Forwarded-For"].FirstOrDefault();
                    if (string.IsNullOrEmpty(ip))
                    {
                        ip = context.Connection.RemoteIpAddress.ToString();
                    }
                    return ip;
                };
                //options.onIntercepted = (context, value, where) =>
                //{
                //    var request = context.Request;
                //    string ip = context.Request.Headers["X-Forwarded-For"].FirstOrDefault();
                //    if (string.IsNullOrEmpty(ip))
                //    {
                //        ip = context.Connection.RemoteIpAddress.ToString();
                //    }
                //    Common.BackListHelper.Add(ip);
                //    string uToken = "";
                //    var parm = Helper.ApiTokenHelper.GetRequestParameters(request, ref uToken);
                //    if (!string.IsNullOrEmpty(uToken))
                //    {
                //        var userInfo = Helper.ApiTokenHelper.ParsingToken(uToken);
                //        if (userInfo != null && !string.IsNullOrEmpty(userInfo.uid))
                //        {
                //            Int32.TryParse(userInfo.uid, out int NewUserId);
                //            if (userInfo.requestFrom == Common.Enum.ApiRequestFromEnum.MiniProgram && NewUserId>0)
                //            {
                //                UserReidsCache.Delete(userInfo.uid);
                //                new EducationModule().UpdateUserBlacklist(NewUserId);
                //            }
                //        }
                //    }
                //    return new ApiThrottleResult() { Content = "ʹƵ!" };
                //};
            });
        }

        /// <summary>
        /// This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        /// </summary>
        /// <param name="app"></param>
        /// <param name="env"></param>
        /// <param name="appLifetime"></param>
        /// <param name="senparcSetting"></param>
        /// <param name="senparcWeixinSetting"></param>
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env, IHostApplicationLifetime appLifetime, IOptions<SenparcSetting> senparcSetting, IOptions<SenparcWeixinSetting> senparcWeixinSetting)
        {
            app.UseForwardedHeaders();
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            
            app.UseApiThrottle();
            app.UseHttpsRedirection();

            app.UseRouting();
            // пcorsConfigureServicesõĿ
            app.UseCors("AllowCors");

            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });

            //  CO2NET ȫעᣬ룡
            IRegisterService register = RegisterService.Start(senparcSetting.Value)
                                                        .UseSenparcGlobal(false, null);

            //ʼע΢Ϣ룡
            register.UseSenparcWeixin(senparcWeixinSetting.Value, senparcSetting.Value);
            System.WebHttpContext.HttpContext.Configure(app.ApplicationServices.GetRequiredService<Microsoft.AspNetCore.Http.IHttpContextAccessor>());
            //Ϣ
            Task.Run(() => MessageCore.Init());

            //ȡǰעQuartz
            //var quartz = app.ApplicationServices.GetRequiredService<QuartzHelper>();
            appLifetime.ApplicationStarted.Register(() =>
            {
                Timers.TimerJobj.RunTimer(); //վִ
            });

            appLifetime.ApplicationStopped.Register(() =>
            {
                Timers.TimerJobj.RunStop();  //վִֹͣ
            });
            string filePath = Path.Combine(Directory.GetCurrentDirectory(), "upfile");
            if (System.IO.Directory.Exists(filePath) == false)//ھʹfileļ
            {
                System.IO.Directory.CreateDirectory(filePath);
            }
            app.UseStaticFiles(new StaticFileOptions
            {
                FileProvider = new Microsoft.Extensions.FileProviders.PhysicalFileProvider(
                Path.Combine(Directory.GetCurrentDirectory(), "upfile")),
                RequestPath = "/upfile"
            });
        }
    }
}
