﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 门店表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Stores_Extend : Model.Entity.User.RB_Stores
    {
        /// <summary>
        /// 排序(1-名称，2-距离，3-热度)
        /// </summary>
        public int OrderByType
        {
            get;set;
        }

        /// <summary>
        /// 当前经度纬度
        /// </summary>
        public string CurrentPosition
        {
            get;set;
        }

        /// <summary>
        /// 距离公里数
        /// </summary>
        public decimal KM { get; set; }

        /// <summary>
        /// 查询门店编号
        /// </summary>
        public string QIds { get; set; }
    }

    /// <summary>
    /// 门店预约实体
    /// </summary>
    public class StoreReserveDate 
    { 
        /// <summary>
        /// 天数
        /// </summary>
        public DateTime DayDate { get; set; }

        /// <summary>
        /// 日期字符串
        /// </summary>
        public string DayDateStr { get; set; }
        
        /// <summary>
        /// 星期
        /// </summary>
        public string WeekDayStr { get; set; }

        /// <summary>
        /// 具体时间点
        /// </summary>
        public List<string> TimeList { get; set; }
    }
}
