﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 分销商提现仓储层
    /// </summary>
    public class RB_Distributor_RemitRepository : RepositoryBase<RB_Distributor_Remit>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Distributor_Remit_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Distributor_Remit_Extend dmodel)
        {
            string where = $@" 1=1 ";
            if (dmodel.TenantId > 0) {
                where += $@" and r.{nameof(RB_Distributor_Remit.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0) {
                where += $@" and r.{nameof(RB_Distributor_Remit.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0) {
                where += $@" and r.{nameof(RB_Distributor_Remit.Id)}={dmodel.Id}";
            }
            if (dmodel.AuditStatus > 0) {
                where += $@" and r.{nameof(RB_Distributor_Remit.AuditStatus)}={(int)dmodel.AuditStatus}";
            }
            if (dmodel.UserId > 0) {
                where += $@" and r.{nameof(RB_Distributor_Remit.UserId)}={dmodel.UserId}";
            }
            
            string sql = $@"select r.*,u.Name as UserName,u.Photo,u.Source from RB_Distributor_Remit r
left join rb_member_user u on r.UserId = u.Id
where {where} order by r.Id desc";
            return GetPage<RB_Distributor_Remit_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Remit_Extend> GetList(RB_Distributor_Remit_Extend dmodel)
        {
            string where = $@" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Remit.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Distributor_Remit.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Distributor_Remit.Id)}={dmodel.Id}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and {nameof(RB_Distributor_Remit.AuditStatus)}={dmodel.AuditStatus}";
            }

            string sql = $@"select * from RB_Distributor_Remit where {where} order by Id desc";
            return Get<RB_Distributor_Remit_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取导出列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Remit_Extend> GetDistributorRemitList(RB_Distributor_Remit_Extend dmodel)
        {
            string where = $@" 1=1 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and r.{nameof(RB_Distributor_Remit.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and r.{nameof(RB_Distributor_Remit.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and r.{nameof(RB_Distributor_Remit.Id)}={dmodel.Id}";
            }
            if (dmodel.AuditStatus > 0)
            {
                where += $@" and r.{nameof(RB_Distributor_Remit.AuditStatus)}={(int)dmodel.AuditStatus}";
            }

            string sql = $@"select r.*,u.Name as UserName,u.Photo,u.Source from RB_Distributor_Remit r
left join rb_member_user u on r.UserId = u.Id
where {where} order by r.Id desc";
            return Get<RB_Distributor_Remit_Extend>(sql).ToList();
        }

        /// <summary>
        /// 获取佣金提现统计
        /// </summary>
        /// <returns></returns>
        public RB_Distributor_Remit_Extend GetDistributorCommissionStatiscs(int userId) {
            string sql = $@"SELECT SUM(CASE WHEN AuditStatus=2 THEN AppliedMoney ELSE 0 END) AS WJSCommission,
SUM(CASE WHEN AuditStatus=3 THEN AppliedMoney ELSE 0 END) AS TXCommission
 FROM rb_distributor_remit WHERE UserId={userId} AND AuditStatus in (2,3) ";

            return Get<RB_Distributor_Remit_Extend>(sql).FirstOrDefault();
        }

        /// <summary>
        /// 获取用户佣金提现
        /// </summary>
        /// <returns></returns>
        public decimal GetDistributorRemitCommission(int userId)
        {
            string sql = $@"SELECT SUM(AppliedMoney) AS WJSCommission FROM rb_distributor_remit WHERE UserId={userId} AND AuditStatus in (1,2,3) ";
            var obj = ExecuteScalar(sql);
            if (obj != null) { return Convert.ToDecimal(obj); } else { return 0; }
        }

        /// <summary>
        /// 获取今日所有用户提现金额
        /// </summary>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public decimal GetAllUserToDayRemitMoney(int tenantId, int mallBaseId)
        {
            string NowTime = DateTime.Now.ToString("yyyy-MM-dd");
            string sql = $@"SELECT SUM(AppliedMoney) as AppliedMoney FROM rb_distributor_remit 
WHERE DATE_FORMAT(CreateDate,'%Y-%m-%d')='{NowTime}' AND AuditStatus in (1,2,3) and TenantId={tenantId} and MallBaseId={mallBaseId}";
            var obj = ExecuteScalar(sql);
            if (obj != null)
            {
                return Convert.ToDecimal(obj);
            }
            else {
                return 0;
            }

        }
    }
}
