﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品订单介绍返佣信息表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderIntroduction
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 订单id
        /// </summary>        
        public int? OrderId
        {
            get;
            set;
        }
        /// <summary>
        /// 订单明细id
        /// </summary>
        public int? OrderDetailId { get; set; }
        /// <summary>
        /// 分销商id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 返利比例  百分比
        /// </summary>        
        public decimal? CommissionRatio
        {
            get;
            set;
        }
        /// <summary>
        /// 佣金
        /// </summary>        
        public decimal? Commission
        {
            get;
            set;
        }
        /// <summary>
        /// 佣金状态  1待返佣   2已返佣  
        /// </summary>        
        public int? CommissionState
        {
            get;
            set;
        }
        /// <summary>
        /// 类型  1介绍供应商返利
        /// </summary>
        public int? Type { get; set; }
        /// <summary>
        /// Remark
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 打款状态   1已打款   2未打款
        /// </summary>
        public int? RemitStatus { get; set; }
    }
}
