﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 员工基础设置表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Employee
    {
        /// <summary>
        /// 员工编号
        /// </summary>        
        public int EmpId
        {
            get;
            set;
        }

        /// <summary>
        /// 员工账号
        /// </summary>        
        public string EmpAccount
        {
            get;
            set;
        }

        /// <summary>
        /// 员工密码
        /// </summary>        
        public string EmpPwd
        {
            get;
            set;
        }

        /// <summary>
        /// 员工姓名
        /// </summary>        
        public string EmpName
        {
            get;
            set;
        }

        /// <summary>
        /// 角色Id
        /// </summary>        
        public string RoleAuth
        {
            get;
            set;
        }

        /// <summary>
        /// 商户号Id
        /// </summary>        
        public int? TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序Id
        /// </summary>        
        public int? MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 状态(0-正常,1-删除)
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateDate { get; set; }
    }
}
