﻿using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 商品关联表仓储层
    /// </summary>
    public class RB_Goods_RelevanceRepository : BaseRepository<RB_Goods_Relevance>
    {
        /// <summary>
        /// 获取关联商品列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Goods_Relevance_Extend> GetGoodsRelevanceListRepository(RB_Goods_Relevance_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_Goods_Relevance AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Goods_Relevance_Extend.Status), 0);
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Goods_Relevance_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Goods_Relevance_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.GoodsId > 0)
            {
                builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Goods_Relevance_Extend.GoodsId), query.GoodsId);
            }
            if (!string.IsNullOrEmpty(query.QRelevanceIds))
            {
                builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Goods_Relevance_Extend.RelevanceId), query.QRelevanceIds);
            }
            if (!string.IsNullOrEmpty(query.QGoodsIds))
            {
                builder.AppendFormat(" AND A.{0} IN({1}) ", nameof(RB_Goods_Relevance_Extend.GoodsId), query.QGoodsIds);
            }
            return Get<RB_Goods_Relevance_Extend>(builder.ToString()).ToList();
        }
    }
}
