﻿using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.User
{
    /// <summary>
    /// 会员订阅微信消息仓储层
    /// </summary>
    public class RB_Member_SubscriptionRepository : BaseRepository<RB_Member_Subscription>
    {

        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Member_Subscription); } }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Member_Subscription_Extend> GetList(RB_Member_Subscription_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from {TableName}  where Status=0");
            if (where != null)
            {
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and UserId={0}", where.UserId);
                }
                if (where.Type > 0)
                {
                    sb.AppendFormat(" and Type={0}", where.Type);
                }
              
                if (!string.IsNullOrEmpty(where.TempleteId))
                {
                    sb.AppendFormat(" and TempleteId ='{0}'", where.TempleteId);
                }
                if (!string.IsNullOrEmpty(where.OpenId))
                {
                    sb.AppendFormat(" and OpenId ='{0}'", where.OpenId);
                }
            }
            return Get<RB_Member_Subscription_Extend>(sb.ToString()).ToList();
        }
    }
}
