﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Common.Enum.User;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 分销商表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Distributor_Info_Extend : RB_Distributor_Info
    {
        /// <summary>
        /// 来自于自主申请  1是 
        /// </summary>
        public int? IsFormSelfApplication { get; set; }
        /// <summary>
        /// 用户来源
        /// </summary>
        public UserSourceEnum? Source { get; set; }

        /// <summary>
        /// 昵称
        /// </summary>
        public string NickName { get; set; }
        /// <summary>
        /// 头像
        /// </summary>
        public string Photo { get; set; }
        /// <summary>
        /// 等级名称
        /// </summary>
        public string GradeName { get; set; }
        /// <summary>
        /// 上级id
        /// </summary>
        public int? SuperiorId { get; set; }
        /// <summary>
        /// 上级名称
        /// </summary>
        public string SuperiorName { get; set; }
        /// <summary>
        /// 一级分销数量
        /// </summary>
        public int? OneNum { get; set; }
        /// <summary>
        /// 二级分销数量
        /// </summary>
        public int? TwoNum { get; set; }
        /// <summary>
        /// 三级分销数量
        /// </summary>
        public int? ThreeNum { get; set; }
        /// <summary>
        /// 用户ids
        /// </summary>
        public string UserIds { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int? OrderNum { get; set; }

        /// <summary>
        /// 下载枚举ids
        /// </summary>
        public List<int> ExcelEnumIds { get; set; }
        /// <summary>
        /// 第几级
        /// </summary>
        public int? ReferralsType { get; set; }
    }
}
