﻿using Mall.IM.Util;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;

namespace Mall.IM.Service.User
{
    public class UserService : BaseService
    {
        /// <summary>
        /// 更新用户名片
        /// </summary>
        private const String updateUinfo = "user/updateUinfo.action";
        /// <summary>
        /// 获取用户名片
        /// </summary>
        private const String getUinfos = "user/getUinfos.action";


        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <param name="account"></param>
        /// <returns></returns>
        public UserServiceResult GetUserInfo(String accID)
        {
            if (String.IsNullOrWhiteSpace(accID))
                throw new ArgumentNullException("参数异常，为null或accid为空");
            String url = String.Format("{0}?accids=[\"{1}\"]", getUinfos, HttpUtility.UrlEncode(accID));
            var apiResult = ApiRequestUtil.PostResponse<UserServiceResult>(ServiceAddress, url);
            return apiResult.Data;

        }
        /// <summary>
        /// 更新账号
        /// </summary>
        /// <param name="account"></param>
        /// <returns></returns>
        public Result UpdateUserInfo(String accID, String icon, String name)
        {
            if (String.IsNullOrWhiteSpace(accID))
                throw new ArgumentNullException("参数异常，为null或accid为空");
            String url = null;
            url = String.Format("{0}?accid={1}&name={2}&icon={3}", updateUinfo, HttpUtility.UrlEncode(accID), HttpUtility.UrlEncode(name),
           HttpUtility.UrlEncode(icon));
            var apiResult = ApiRequestUtil.PostResponse<Result>(ServiceAddress, url);
            return apiResult.Data;
        }


    }
}
