﻿using Mall.Model.Entity.Product;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Product
{
    public class RB_Goods_OrderDetailFreeShippingRepository : BaseRepository<RB_Goods_OrderDetailFreeShipping>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Goods_OrderDetailFreeShipping); } }
        /// <summary>
        /// 物料规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetailFreeShipping> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Goods_OrderDetailFreeShipping query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE  {nameof(RB_Goods_OrderDetailFreeShipping.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Goods_OrderDetailFreeShipping.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Goods_OrderDetailFreeShipping.MallBaseId)}={query.MallBaseId}");
                }
                if (query.OrderDetailId > 0)
                {
                    builder.Append($" AND {nameof(RB_Goods_OrderDetailFreeShipping.OrderDetailId)}={query.OrderDetailId}");
                }
            }
            return GetPage<RB_Goods_OrderDetailFreeShipping>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 物流规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Goods_OrderDetailFreeShipping> GetLogisticsRulesList(RB_Goods_OrderDetailFreeShipping query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Goods_OrderDetailFreeShipping.Status)}=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Goods_OrderDetailFreeShipping.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Goods_OrderDetailFreeShipping.MallBaseId)}={query.MallBaseId}");
                }
                if (query.OrderDetailId > 0)
                {
                    builder.Append($" AND {nameof(RB_Goods_OrderDetailFreeShipping.OrderDetailId)}={query.OrderDetailId}");
                }
            }
            return Get<RB_Goods_OrderDetailFreeShipping>(builder.ToString()).ToList();
        }

    }
}
