﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Common.Enum.MallBase
{
    /// <summary>
    /// 页面类型枚举  (1-基础页面,2-营销页面，3-订单页面，4-插件页面，5-diy页面
    /// </summary>
    public enum PageTypeEnum
    {
        /// <summary>
        /// 基础页面
        /// </summary>
        [EnumField("基础页面")]
        BasicPage = 1,

        /// <summary>
        /// 营销页面
        /// </summary>
        [EnumField("营销页面")]
        MarketingPage = 2,


        /// <summary>
        /// 订单页面
        /// </summary>
        [EnumField("订单页面")]
        OrderPage = 3,

        /// <summary>
        /// 插件页面
        /// </summary>
        [EnumField("插件页面")]
        PluginPage = 4,


        /// <summary>
        /// diy页面
        /// </summary>
        [EnumField("diy页面")]
        DiyPage = 4,
    }
}
