﻿using Mall.Common.AOP;
using Mall.Common.Enum.MallBase;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 小程序页面管理实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Miniprogram_PageManage
    {
        /// <summary>
        /// 页面编号
        /// </summary>        
        public int PageId
        {
            get;
            set;
        }

        /// <summary>
        /// 页面类型(1-基础页面,2-营销页面，3-订单页面，4-插件页面，5-diy页面
        /// </summary>        
        public PageTypeEnum PageType
        {
            get;
            set;
        }

        /// <summary>
        /// 页面名称
        /// </summary>        
        public string PageName
        {
            get;
            set;
        }

        /// <summary>
        /// 页面地址
        /// </summary>        
        public string PageUrl
        {
            get;
            set;
        }

        /// <summary>
        /// 页面排序
        /// </summary>        
        public int? PageSort
        {
            get;
            set;
        }

        /// <summary>
        /// 是否有参数
        /// </summary>        
        public int? IsParameter
        {
            get;
            set;
        }

        /// <summary>
        /// 参数值
        /// </summary>        
        public string ParameterValue
        {
            get;
            set;
        }

        /// <summary>
        /// 状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
    }
}
