﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using Mall.Repository.Product;
using Mall.Model.Extend.Product;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;

namespace Mall.Module.User
{
    /// <summary>
    /// 商户用户处理层
    /// </summary>
    public class UserModule
    {
        /// <summary>
        /// 用户管理
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        /// <summary>
        /// 会员等级
        /// </summary>
        private readonly RB_Member_GradeRepository member_GradeRepository = new RB_Member_GradeRepository();
        /// <summary>
        /// 会员权益
        /// </summary>
        private readonly RB_Member_EquityRepository member_EquityRepository = new RB_Member_EquityRepository();
        /// <summary>
        /// 用户积分
        /// </summary>
        private readonly RB_Member_IntegralRepository member_IntegralRepository = new RB_Member_IntegralRepository();
        /// <summary>
        /// 用户余额
        /// </summary>
        private readonly RB_Member_BalanceRepository member_BalanceRepository = new RB_Member_BalanceRepository();
        /// <summary>
        /// 素材
        /// </summary>
        private readonly RB_Material_InfoRepository material_InfoRepository = new RB_Material_InfoRepository();
        /// <summary>
        /// 分销基础配置
        /// </summary>
        private readonly RB_Distributor_BasicsRepository distributor_BasicsRepository = new RB_Distributor_BasicsRepository();
        /// <summary>
        /// 分销自定义设置
        /// </summary>
        private readonly RB_Distributor_CustomRepository distributor_CustomRepository = new RB_Distributor_CustomRepository();
        /// <summary>
        /// 分销商等级
        /// </summary>
        private readonly RB_Distributor_GradeRepository distributor_GradeRepository = new RB_Distributor_GradeRepository();
        /// <summary>
        /// 分销商
        /// </summary>
        private readonly RB_Distributor_InfoRepository distributor_InfoRepository = new RB_Distributor_InfoRepository();


        /// <summary>
        /// 获取用户分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserPageList(int pageIndex, int pageSize, out long count, RB_Member_User_Extend dmodel) {
            var list= member_UserRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
            if (list.Any()) {
                List<RB_Member_Grade_Extend> gradeList = new List<RB_Member_Grade_Extend>();
                if (list.Where(x => x.MemberGrade > 0).Any())
                {
                    var gradeIds = string.Join(",", list.Where(x => x.MemberGrade > 0).Select(x => x.MemberGrade ?? 0));
                    gradeList = member_GradeRepository.GetList(new RB_Member_Grade_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list) {
                    if (item.MemberGrade > 0)
                    {
                        item.MemberGradeName = gradeList.Where(x => x.Id == item.MemberGrade).FirstOrDefault()?.Name ?? "";
                    }
                    else {
                        item.MemberGradeName = "普通会员";
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取下拉列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserDropDownList(int pageIndex, int pageSize, out long count, RB_Member_User_Extend demodel)
        {
            return member_UserRepository.GetMemberUserDropDownList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public RB_Member_User_Extend GetMemberUserInfo(int userId)
        {
            return member_UserRepository.GetEntity(userId).RefMapperTo<RB_Member_User_Extend>();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserList(RB_Member_User_Extend dmodel)
        {
            var list = member_UserRepository.GetList(dmodel);
            if (list.Any())
            {
                List<RB_Member_Grade_Extend> gradeList = new List<RB_Member_Grade_Extend>();
                if (list.Where(x => x.MemberGrade > 0).Any())
                {
                    var gradeIds = string.Join(",", list.Where(x => x.MemberGrade > 0).Select(x => x.MemberGrade ?? 0));
                    gradeList = member_GradeRepository.GetList(new RB_Member_Grade_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    if (item.MemberGrade > 0)
                    {
                        item.MemberGradeName = gradeList.Where(x => x.Id == item.MemberGrade).FirstOrDefault()?.Name ?? "";
                    }
                    else
                    {
                        item.MemberGradeName = "普通会员";
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取等级分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGradePageList(int pageIndex, int pageSize, out long count, RB_Member_Grade_Extend dmodel) {
            var list = member_GradeRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
            if (list.Any()) {
                string Ids = string.Join(",", list.Select(x => x.Id));
                var elist = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeIds = Ids, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });

                List<int> MaterialIds = new List<int>();
                MaterialIds.AddRange(list.Select(x => x.Icon ?? 0).Distinct().ToList());
                MaterialIds.AddRange(list.Select(x => x.BackgroundImage ?? 0).Distinct().ToList());
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (MaterialIds.Any()) {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", MaterialIds), TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list) {
                    item.EquityList = elist.Where(x => x.GradeId == item.Id).ToList();
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                    item.BackgroundImagePath = mlist.Where(x => x.Id == item.BackgroundImage).FirstOrDefault()?.Path ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 后台修改用户信息
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberUserInfoForHT(RB_Member_User_Extend demodel)
        {
            Dictionary<string, object> files = new Dictionary<string, object>() {
                { nameof(RB_Member_User.MemberGrade),demodel.MemberGrade},
                { nameof(RB_Member_User.SuperiorId),demodel.SuperiorId},
                { nameof(RB_Member_User.ContactWay),demodel.ContactWay},
                { nameof(RB_Member_User.Remark),demodel.Remark},
                { nameof(RB_Member_User.AliasName),demodel.AliasName},
                { nameof(RB_Member_Grade.UpdateDate),demodel.UpdateDate}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Member_User.Id),
                    FiledValue=demodel.Id,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            return member_UserRepository.Update(files, wheres);
        }

        /// <summary>
        /// 获取会员等级列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGradeList(RB_Member_Grade_Extend dmodel)
        {
            var list = member_GradeRepository.GetList(dmodel);
            if (list.Any())
            {
                string Ids = string.Join(",", list.Select(x => x.Id));
                var elist = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeIds = Ids, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });

                List<int> MaterialIds = new List<int>();
                MaterialIds.AddRange(list.Select(x => x.Icon ?? 0).Distinct().ToList());
                MaterialIds.AddRange(list.Select(x => x.BackgroundImage ?? 0).Distinct().ToList());
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (MaterialIds.Any())
                {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", MaterialIds), TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    item.EquityList = elist.Where(x => x.GradeId == item.Id).ToList();
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                    item.BackgroundImagePath = mlist.Where(x => x.Id == item.BackgroundImage).FirstOrDefault()?.Path ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 新增会员等级
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberGradeInfo(RB_Member_Grade_Extend demodel)
        {
            var trans = member_GradeRepository.DbTransaction;
            try
            {
                if (demodel.Id > 0)
                {
                    Dictionary<string, object> files = new Dictionary<string, object>() {
                        { nameof(RB_Member_Grade.BackgroundImage),demodel.BackgroundImage},
                        { nameof(RB_Member_Grade.Discount),demodel.Discount},
                        { nameof(RB_Member_Grade.Enabled),demodel.Enabled},
                        { nameof(RB_Member_Grade.Grade),demodel.Grade},
                        { nameof(RB_Member_Grade.Icon),demodel.Icon},
                        { nameof(RB_Member_Grade.IsAutoUpGrade),demodel.IsAutoUpGrade},
                        { nameof(RB_Member_Grade.IsMemberBuy),demodel.IsMemberBuy},
                        { nameof(RB_Member_Grade.MemberBuyMoney),demodel.MemberBuyMoney},
                        { nameof(RB_Member_Grade.MemberSpecification),demodel.MemberSpecification},
                        { nameof(RB_Member_Grade.Name),demodel.Name},
                        { nameof(RB_Member_Grade.UpGradeMoney),demodel.UpGradeMoney},
                        { nameof(RB_Member_Grade.UpdateDate),demodel.UpdateDate},
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                         FiledName=nameof(RB_Member_Grade.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    bool flag = member_GradeRepository.Update(files, wheres, trans);
                    if (flag) {
                        var elist = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeId = demodel.Id });
                        List<RB_Member_Equity_Extend> InsertList = new List<RB_Member_Equity_Extend>();
                        List<RB_Member_Equity_Extend> UpdateList = new List<RB_Member_Equity_Extend>();
                        List<RB_Member_Equity_Extend> DeleteList = new List<RB_Member_Equity_Extend>();
                        if (demodel.EquityList != null && demodel.EquityList.Any()) {
                            InsertList = demodel.EquityList.Where(x => x.Id == 0).ToList();
                            UpdateList = demodel.EquityList.Where(x => elist.Select(y => y.Id).Contains(x.Id)).ToList();
                            DeleteList = elist.Where(x => !demodel.EquityList.Select(y => y.Id).Contains(x.Id)).ToList();
                        }
                        foreach (var item in InsertList) {
                            member_EquityRepository.Insert(new RB_Member_Equity()
                            {
                                Content = item.Content,
                                CreateDate = demodel.CreateDate,
                                GradeId = demodel.Id,
                                Id = 0,
                                Image = item.Image,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId,
                                Title = item.Title,
                                UpdateDate = demodel.CreateDate
                            }, trans);
                        }
                        foreach (var item in UpdateList) {
                            Dictionary<string, object> cols = new Dictionary<string, object>() {
                                { nameof(RB_Member_Equity.Content),item.Content},
                                { nameof(RB_Member_Equity.Image),item.Image},
                                { nameof(RB_Member_Equity.Title),item.Title},
                                { nameof(RB_Member_Equity.UpdateDate),demodel.UpdateDate},
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Member_Equity.Id),
                                      FiledValue=item.Id,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            member_EquityRepository.Update(cols, wheres1, trans);
                        }
                        foreach (var item in DeleteList) {
                            Dictionary<string, object> cols = new Dictionary<string, object>() {
                                { nameof(RB_Member_Equity.Status),1},
                                { nameof(RB_Member_Equity.UpdateDate),demodel.UpdateDate},
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Member_Equity.Id),
                                      FiledValue=item.Id,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            member_EquityRepository.Update(cols, wheres1, trans);
                        }
                    }
                    member_GradeRepository.DBSession.Commit();
                    return flag;
                }
                else
                {
                    int Id = member_GradeRepository.Insert(demodel, trans);
                    bool flag = Id > 0;
                    if (flag)
                    {
                        //插入权益
                        if (demodel.EquityList != null && demodel.EquityList.Any())
                        {
                            foreach (var item in demodel.EquityList)
                            {
                                member_EquityRepository.Insert(new Model.Entity.User.RB_Member_Equity()
                                {
                                    Content = item.Content,
                                    CreateDate = demodel.CreateDate,
                                    GradeId = Id,
                                    Id = 0,
                                    Image = item.Image,
                                    MallBaseId = demodel.MallBaseId,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    Title = item.Title,
                                    UpdateDate = demodel.CreateDate
                                }, trans);
                            }
                        }
                    }
                    member_GradeRepository.DBSession.Commit();
                    return flag;
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetMemberGradeInfo");
                member_GradeRepository.DBSession.Rollback();
                return false;
            }
        }

        /// <summary>
        /// 获取会员等级
        /// </summary>
        /// <param name="gradeId"></param>
        /// <returns></returns>
        public RB_Member_Grade_Extend GetMemberGradeInfo(int gradeId)
        {
            var model = member_GradeRepository.GetEntity(gradeId).RefMapperTo<RB_Member_Grade_Extend>();
            if (model == null)
            {
                return new RB_Member_Grade_Extend();
            }
            model.EquityList = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeId = model.Id });
            model.IconPath = material_InfoRepository.GetEntity(model.Icon)?.Path ?? "";
            model.BackgroundImagePath = material_InfoRepository.GetEntity(model.BackgroundImage)?.Path ?? "";
            return model;
        }

        /// <summary>
        /// 删除会员等级
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelMemberGradeInfo(int gradeId, string uid)
        {
            Dictionary<string, object> cols = new Dictionary<string, object>() {
                { nameof(RB_Member_Grade.Status),1},
                { nameof(RB_Member_Grade.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Member_Grade.Id),
                        FiledValue=gradeId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Member_Grade.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return member_GradeRepository.Update(cols, wheres1);
        }

        /// <summary>
        /// 获取积分分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetMemberIntegralPageList(int pageIndex, int pageSize, out long count, RB_Member_Integral_Extend demodel)
        {
            return member_IntegralRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 保存积分
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberIntegralInfo(RB_Member_Integral_Extend demodel)
        {
            var umodel = member_UserRepository.GetEntity(demodel.UserId);
            int Integral = 0;
            if (demodel.Type == 1)
            {
                Integral = (umodel.Integral ?? 0) + (demodel.Integral ?? 0);
            }
            else {
                Integral = (umodel.Integral ?? 0) - (demodel.Integral ?? 0);
            }
            if (Integral < 0) {
                Integral = 0;
            }
            Dictionary<string, object> keys = new Dictionary<string, object>() {
                { nameof(RB_Member_User.Integral),Integral}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Member_User.Id),
                    FiledValue=demodel.UserId,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = member_UserRepository.Update(keys, wheres);
            if (flag)
            {
                return member_IntegralRepository.Insert(demodel) > 0;
            }
            return false;
        }

        /// <summary>
        /// 获取余额分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_Balance_Extend> GetMemberBalancePageList(int pageIndex, int pageSize, out long count, RB_Member_Balance_Extend demodel)
        {
            return member_BalanceRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 保存余额充值
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberBalanceInfo(RB_Member_Balance_Extend demodel)
        {
            var umodel = member_UserRepository.GetEntity(demodel.UserId);
            decimal Balance = 0;
            if (demodel.Type == 1)
            {
                Balance = (umodel.Balance ?? 0) + (demodel.Balance ?? 0);
            }
            else
            {
                Balance = (umodel.Balance ?? 0) - (demodel.Balance ?? 0);
            }
            if (Balance < 0)
            {
                Balance = 0;
            }
            Dictionary<string, object> keys = new Dictionary<string, object>() {
                { nameof(RB_Member_User.Balance),Balance}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Member_User.Id),
                    FiledValue=demodel.UserId,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = member_UserRepository.Update(keys, wheres);
            if (flag)
            {
                return member_BalanceRepository.Insert(demodel) > 0;
            }
            return false;
        }

        /// <summary>
        /// 设置分销基础配置
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetDistributorBasicsInfo(RB_Distributor_Basics_Extend demodel)
        {
            demodel.GradeEntranceImage = new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("InitializeImages")["GradeEntranceImage"];
            var OModel = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (OModel != null)
            {
                demodel.Id = OModel.Id;
                Dictionary<string, object> keyValuePairs = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Basics.DistributorTier),demodel.DistributorTier},
                    { nameof(RB_Distributor_Basics.InPurchasing),demodel.InPurchasing},
                    { nameof(RB_Distributor_Basics.ReferralsCondition),demodel.ReferralsCondition},
                    { nameof(RB_Distributor_Basics.ApplyFor),demodel.ApplyFor},
                    { nameof(RB_Distributor_Basics.DistributorCondition),demodel.DistributorCondition},
                    { nameof(RB_Distributor_Basics.DistributorCommissionType),demodel.DistributorCommissionType},
                    { nameof(RB_Distributor_Basics.OneCommission),demodel.OneCommission},
                    { nameof(RB_Distributor_Basics.TwoCommission),demodel.TwoCommission},
                    { nameof(RB_Distributor_Basics.ThreeCommission),demodel.ThreeCommission},
                    { nameof(RB_Distributor_Basics.GradeEntrance),demodel.GradeEntrance},
                    { nameof(RB_Distributor_Basics.GradeEntranceImage),demodel.GradeEntranceImage},
                    { nameof(RB_Distributor_Basics.WithdrawWay),demodel.WithdrawWay},
                    { nameof(RB_Distributor_Basics.MinimumWithdrawalLimit),demodel.MinimumWithdrawalLimit},
                    { nameof(RB_Distributor_Basics.DailyWithdrawalLimit),demodel.DailyWithdrawalLimit},
                    { nameof(RB_Distributor_Basics.WithdrawFee),demodel.WithdrawFee},
                    { nameof(RB_Distributor_Basics.ApplicationProtocol),demodel.ApplicationProtocol},
                    { nameof(RB_Distributor_Basics.UserNotes),demodel.UserNotes},
                    { nameof(RB_Distributor_Basics.BackgroundImage),demodel.BackgroundImage},
                    { nameof(RB_Distributor_Basics.IndexImage),demodel.IndexImage},
                    { nameof(RB_Distributor_Basics.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Basics.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Basics.TenantId),
                          FiledValue=demodel.TenantId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Basics.MallBaseId),
                          FiledValue=demodel.MallBaseId,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return distributor_BasicsRepository.Update(keyValuePairs, whereHelpers);
            }
            else
            {
                return distributor_BasicsRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 获取分销基础信息
        /// </summary>
        /// <param name="basicsId"></param>
        /// <returns></returns>
        public RB_Distributor_Basics_Extend GetDistributorBasicsInfo(int basicsId)
        {
            var model = distributor_BasicsRepository.GetEntity(basicsId).RefMapperTo<RB_Distributor_Basics_Extend>();
            if (model == null) {
                return new RB_Distributor_Basics_Extend();
            }
            model.IndexImagePath = material_InfoRepository.GetEntity(model.IndexImage)?.Path ?? "";
            model.BackgroundImagePath = material_InfoRepository.GetEntity(model.BackgroundImage)?.Path ?? "";
            return model;
        }

        /// <summary>
        /// 获取分销基础信息
        /// </summary>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Distributor_Basics_Extend GetDistributorBasicsInfo(string uid, int mallBaseId)
        {
            var model = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return new RB_Distributor_Basics_Extend();
            }
            model.IndexImagePath = material_InfoRepository.GetEntity(model.IndexImage)?.Path ?? "";
            model.BackgroundImagePath = material_InfoRepository.GetEntity(model.BackgroundImage)?.Path ?? "";
            return model;
        }

        /// <summary>
        /// 设置分销自定义
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetDistributorCustomInfo(RB_Distributor_Custom_Extend demodel)
        {
            var OModel = distributor_CustomRepository.GetList(new RB_Distributor_Custom_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (OModel != null)
            {
                demodel.Id = OModel.Id;
                Dictionary<string, object> keyValuePairs = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Custom.HeadImage),demodel.HeadImage},
                    { nameof(RB_Distributor_Custom.BottomImage),demodel.BottomImage},
                    { nameof(RB_Distributor_Custom.DistributionApplication),demodel.DistributionApplication},
                    { nameof(RB_Distributor_Custom.ApplicationAgreement),demodel.ApplicationAgreement},
                    { nameof(RB_Distributor_Custom.ButtonFilletPX),demodel.ButtonFilletPX},
                    { nameof(RB_Distributor_Custom.ButtonText),demodel.ButtonText},
                    { nameof(RB_Distributor_Custom.ButtonColor),demodel.ButtonColor},
                    { nameof(RB_Distributor_Custom.ButtonTextColor),demodel.ButtonTextColor},
                    { nameof(RB_Distributor_Custom.DistributionCommissionName),demodel.DistributionCommissionName},
                    { nameof(RB_Distributor_Custom.DistributionCommissionImage),demodel.DistributionCommissionImage},
                    { nameof(RB_Distributor_Custom.DistributionOrderName),demodel.DistributionOrderName},
                    { nameof(RB_Distributor_Custom.DistributionOrderImage),demodel.DistributionOrderImage},
                    { nameof(RB_Distributor_Custom.WithdrawDetialsName),demodel.WithdrawDetialsName},
                    { nameof(RB_Distributor_Custom.WithdrawDetialsImage),demodel.WithdrawDetialsImage},
                    { nameof(RB_Distributor_Custom.MyTeamName),demodel.MyTeamName},
                    { nameof(RB_Distributor_Custom.MyTeamImage),demodel.MyTeamImage},
                    { nameof(RB_Distributor_Custom.PromoteQRCodeName),demodel.PromoteQRCodeName},
                    { nameof(RB_Distributor_Custom.PromoteQRCodeImage),demodel.PromoteQRCodeImage},
                    { nameof(RB_Distributor_Custom.ReferrerName),demodel.ReferrerName},
                    { nameof(RB_Distributor_Custom.CommissionForWithdrawalName),demodel.CommissionForWithdrawalName},
                    { nameof(RB_Distributor_Custom.WithdrawDepositName),demodel.WithdrawDepositName},
                    { nameof(RB_Distributor_Custom.CommissionWithdrawnName),demodel.CommissionWithdrawnName},
                    { nameof(RB_Distributor_Custom.OutstandingCommissionName),demodel.OutstandingCommissionName},
                    { nameof(RB_Distributor_Custom.DistributorName),demodel.DistributorName},
                    { nameof(RB_Distributor_Custom.CommissionTobePaidName),demodel.CommissionTobePaidName},
                    { nameof(RB_Distributor_Custom.UserNotesName),demodel.UserNotesName},
                    { nameof(RB_Distributor_Custom.IWantToWithdrawName),demodel.IWantToWithdrawName},
                    { nameof(RB_Distributor_Custom.WithdrawalAmountName),demodel.WithdrawalAmountName},
                    { nameof(RB_Distributor_Custom.WithdrawalWayName),demodel.WithdrawalWayName},
                    { nameof(RB_Distributor_Custom.OneDistributionName),demodel.OneDistributionName},
                    { nameof(RB_Distributor_Custom.TwoDistributionName),demodel.TwoDistributionName},
                    { nameof(RB_Distributor_Custom.ThreeDistributionName),demodel.ThreeDistributionName},
                    { nameof(RB_Distributor_Custom.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Custom.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Custom.TenantId),
                          FiledValue=demodel.TenantId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Custom.MallBaseId),
                          FiledValue=demodel.MallBaseId,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return distributor_CustomRepository.Update(keyValuePairs, whereHelpers);
            }
            else
            {
                return distributor_CustomRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 获取分销自定义信息
        /// </summary>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Distributor_Custom_Extend GetDistributorCustomInfo(string uid, int mallBaseId)
        {
            var model = distributor_CustomRepository.GetList(new RB_Distributor_Custom_Extend() { TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return new RB_Distributor_Custom_Extend();
            }
            model.BottomImagePath = material_InfoRepository.GetEntity(model.BottomImage)?.Path ?? "";
            model.DistributionCommissionImagePath = material_InfoRepository.GetEntity(model.DistributionCommissionImage)?.Path ?? "";
            model.DistributionOrderImagePath = material_InfoRepository.GetEntity(model.DistributionOrderImage)?.Path ?? "";
            model.HeadImagePath = material_InfoRepository.GetEntity(model.HeadImage)?.Path ?? "";
            model.MyTeamImagePath = material_InfoRepository.GetEntity(model.MyTeamImage)?.Path ?? "";
            model.PromoteQRCodeImagePath = material_InfoRepository.GetEntity(model.PromoteQRCodeImage)?.Path ?? "";
            model.WithdrawDetialsImagePath = material_InfoRepository.GetEntity(model.WithdrawDetialsImage)?.Path ?? "";
            return model;
        }

        /// <summary>
        /// 获取等级分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Grade_Extend> GetDistributorGradePageList(int pageIndex, int pageSize, out long count, RB_Distributor_Grade_Extend demodel)
        {
            var list= distributor_GradeRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            //获取分销商基础
            var bmodel = GetDistributorBasicsInfo(demodel.TenantId.ToString(), demodel.MallBaseId);
            if (bmodel != null) {
                switch (bmodel.DistributorTier) {
                    case 0:
                        foreach (var item in list)
                        {
                            item.OneCommission = -1;
                            item.TwoCommission = -1;
                            item.ThreeCommission = -1;
                        }
                        break;
                    case 1:
                        foreach (var item in list)
                        {
                            item.TwoCommission = -1;
                            item.ThreeCommission = -1;
                        }
                        break;
                    case 2:
                        foreach (var item in list)
                        {
                            item.ThreeCommission = -1;
                        }
                        break;
                }
            }
            return list;
        }

        /// <summary>
        /// 新增修改分销商等级
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetDistributorGradeInfo(RB_Distributor_Grade_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                var model = distributor_GradeRepository.GetEntity(demodel.Id);
                if (model == null)
                {
                    return false;
                }
                if (model.TenantId != demodel.TenantId)
                {
                    return false;
                }
                if (model.MallBaseId != demodel.MallBaseId)
                {
                    return false;
                }

                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Grade.CommissionWithdrawn),demodel.CommissionWithdrawn},
                    { nameof(RB_Distributor_Grade.DistributionCommissionType),demodel.DistributionCommissionType},
                    { nameof(RB_Distributor_Grade.Enabled),demodel.Enabled},
                    { nameof(RB_Distributor_Grade.Grade),demodel.Grade},
                    { nameof(RB_Distributor_Grade.GradeExplain),demodel.GradeExplain},
                    { nameof(RB_Distributor_Grade.IsAutoUpGrade),demodel.IsAutoUpGrade},
                    { nameof(RB_Distributor_Grade.Name),demodel.Name},
                    { nameof(RB_Distributor_Grade.OneCommission),demodel.OneCommission},
                    { nameof(RB_Distributor_Grade.ReferralsNumber),demodel.ReferralsNumber},
                    { nameof(RB_Distributor_Grade.ThreeCommission),demodel.ThreeCommission},
                    { nameof(RB_Distributor_Grade.TotalCommission),demodel.TotalCommission},
                    { nameof(RB_Distributor_Grade.TwoCommission),demodel.TwoCommission},
                    { nameof(RB_Distributor_Grade.UpGradeCondition),demodel.UpGradeCondition},
                    { nameof(RB_Distributor_Grade.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Grade.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                bool flag = distributor_GradeRepository.Update(keyValues, whereHelpers);
                if (flag) {
                    if (model.Enabled == 1 && demodel.Enabled == 2)
                    {
                        //由启用设置为停用  需更新该等级下的用户为默认等级
                        member_UserRepository.UpdateMemberGrade(GradeId: demodel.Id, DefaultGId: 0, demodel.TenantId, demodel.MallBaseId);
                    }
                }
                return flag;
            }
            else {
                return distributor_GradeRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelDistributorGradeInfo(int gradeId, string uid, int mallBaseId)
        {
            var gmodel = distributor_GradeRepository.GetEntity(gradeId);
            if (gmodel == null) {
                return false;
            }
            if (gmodel.TenantId != Convert.ToInt32(uid)) {
                return false;
            }
            if (gmodel.MallBaseId != mallBaseId) {
                return false;
            }
            if (gmodel.Enabled == 1) {
                return false;
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Distributor_Grade.Status),1},
                { nameof(RB_Distributor_Grade.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_Grade.Id),
                        FiledValue=gradeId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return distributor_GradeRepository.Update(keyValues, whereHelpers);
        }

        /// <summary>
        /// 获取分销商等级信息
        /// </summary>
        /// <param name="gradeId"></param>
        /// <returns></returns>
        public RB_Distributor_Grade GetDistributorGradeInfo(int gradeId)
        {
            return distributor_GradeRepository.GetEntity(gradeId);
        }

        /// <summary>
        /// 获取分销商分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Info_Extend> GetDistributorInfoPageList(int pageIndex, int pageSize, out long count, RB_Distributor_Info_Extend demodel)
        {
            var list = distributor_InfoRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any()) {
                //查询分销商等级
                string gradeIds = string.Join(",", list.Where(x => x.GradeId > 0).Select(x => x.GradeId ?? 0).Distinct());
                List<RB_Distributor_Grade_Extend> GradeList = new List<RB_Distributor_Grade_Extend>();
                if (!string.IsNullOrEmpty(gradeIds))
                {
                    GradeList = distributor_GradeRepository.GetList(new RB_Distributor_Grade_Extend() { GradeIds = gradeIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                //查询推荐人列表
                string tjrIds = string.Join(",", list.Where(x => x.SuperiorId > 0).Select(x => x.SuperiorId ?? 0).Distinct());
                List<RB_Member_User_Extend> UserList = new List<RB_Member_User_Extend>();
                if (!string.IsNullOrEmpty(tjrIds)) {
                    UserList = member_UserRepository.GetList(new RB_Member_User_Extend() { UserIds = tjrIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                //根据基础配置层级查询下级数量  暂放弃
                //var basmdoel = GetDistributorBasicsInfo(demodel.TenantId.ToString(), demodel.MallBaseId);
                //if (basmdoel != null && basmdoel.DistributorTier > 0) {
                string uids = string.Join(",", list.Select(x => x.UserId ?? 0));
                List<RB_Member_User_Extend> UserNum1List = member_UserRepository.GetDistributorReferralsNum(uids, tier: 1, tenantId: demodel.TenantId, mallBaseId: demodel.MallBaseId);//直接查询三级
                List<RB_Member_User_Extend> UserNum2List = member_UserRepository.GetDistributorReferralsNum(uids, tier: 2, tenantId: demodel.TenantId, mallBaseId: demodel.MallBaseId);//直接查询三级
                List<RB_Member_User_Extend> UserNum3List = member_UserRepository.GetDistributorReferralsNum(uids, tier: 3, tenantId: demodel.TenantId, mallBaseId: demodel.MallBaseId);//直接查询三级

                foreach (var item in list) {
                    if (item.GradeId == 0)
                    {
                        item.GradeName = "默认等级";
                    }
                    else if (item.GradeId > 0)
                    {
                        item.GradeName = GradeList.Where(x => x.Id == item.GradeId).FirstOrDefault()?.Name ?? "";
                    }
                    if (item.SuperiorId == 0)
                    {
                        item.SuperiorName = "总店";
                    }
                    else if (item.SuperiorId > 0) {
                        item.SuperiorName = UserList.Where(x => x.Id == item.SuperiorId).FirstOrDefault()?.Name ?? "";
                    }
                    item.OneNum = 0;
                    if (UserNum1List.Any()) {
                        item.OneNum = UserNum1List.Where(x => x.SuperiorId == item.UserId).FirstOrDefault()?.ReferralsNum ?? 0;
                    }
                    item.TwoNum = 0;
                    if (UserNum1List.Any())
                    {
                        item.TwoNum = UserNum2List.Where(x => x.SuperiorId == item.UserId).FirstOrDefault()?.ReferralsNum ?? 0;
                    }
                    item.ThreeNum = 0;
                    if (UserNum1List.Any())
                    {
                        item.ThreeNum = UserNum3List.Where(x => x.SuperiorId == item.UserId).FirstOrDefault()?.ReferralsNum ?? 0;
                    }
                }

            }
            return list;
        }

        /// <summary>
        /// 新增分销商
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetDistributorInfo(RB_Distributor_Info_Extend demodel)
        {
            demodel.TotalCommission ??= 0;
            demodel.CommissionWithdrawal ??= 0;
            demodel.Name ??= "";
            demodel.GradeId ??= 0;
            demodel.AuditStatus = 1;
            return distributor_InfoRepository.Insert(demodel) > 0;
        }

        /// <summary>
        /// 验证分销商
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public string ValidateDistributorInfo(int? userId, int tenantId, int mallBaseId)
        {
            var model = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = userId, TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return "";
            }
            if (model.AuditStatus == 3)
            {
                return "已被拒绝，无法再次申请";
            }
            else if (model.AuditStatus == 1)
            {
                return "申请正在审核中，无法再次申请";
            }
            else if (model.AuditStatus == 2)
            {
                return "已经成为分销商，无法再次申请";
            }
            return "";
        }

        /// <summary>
        /// 分销商审核+修改等级
        /// </summary>
        /// <param name="userIds"></param>
        /// <param name="type"></param>
        /// <param name="newGradeId"></param>
        /// <param name="remark"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public string SetDistributorAudit(string userIds, int type, int newGradeId,string remark, string uid, int mallBaseId)
        {
            var trans = distributor_InfoRepository.DbTransaction;
            try
            {
                if (type == 1)
                {
                    var list = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserIds = userIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    foreach (var item in list)
                    {
                        if (item.AuditStatus != 1)
                        {
                            return "用户ID:" + item.UserId + " 不是未审核状态，无法通过";
                        }
                    }
                    //批量修改状态
                    foreach (var item in list)
                    {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Distributor_Info.AuditStatus),2},
                            { nameof(RB_Distributor_Info.AuditDate),DateTime.Now}
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                 FiledName=nameof(RB_Distributor_Info.Id),
                                  FiledValue=item.Id,
                                   OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        bool flag = distributor_InfoRepository.Update(keyValues, wheres, trans);
                        if (flag)
                        {
                            //修改用户表状态
                            Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                { nameof(RB_Member_User.IsDistributor),1}
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Member_User.Id),
                                      FiledValue=item.UserId,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            member_UserRepository.Update(keyValues1, wheres1, trans);
                        }
                    }
                }
            }
            catch (Exception)
            {

                throw;
            }
            return "";
        }
    }
}
