﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 角色表仓储层
    /// </summary>
    public class RB_RoleRepository : RepositoryBase<RB_Role>
    {
        /// <summary>
        /// 角色分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Role_Extend> GetRolePageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Role_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Role WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.RoleId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_Extend.RoleId), query.RoleId);
            }
            if (query.RoleName != null && !string.IsNullOrEmpty(query.RoleName.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Role_Extend.RoleName), query.RoleName.Trim());
            }
          
            return GetPage<RB_Role_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取角色列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Role_Extend> GetRoleListRepository(RB_Role_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" SELECT * FROM RB_Role WHERE 1=1 AND Status=0 ");
            if (query.TenantId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_Extend.TenantId), query.TenantId);
            }
            if (query.MallBaseId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_Extend.MallBaseId), query.MallBaseId);
            }
            if (query.RoleId > 0)
            {
                builder.AppendFormat(" AND {0}={1} ", nameof(RB_Role_Extend.RoleId), query.RoleId);
            }
            if (query.RoleName != null && !string.IsNullOrEmpty(query.RoleName.Trim()))
            {
                builder.AppendFormat(" AND {0} LIKE '%{1}%' ", nameof(RB_Role_Extend.RoleName), query.RoleName.Trim());
            }
            return Get<RB_Role_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 根据员工编号获取角色权限
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Role_Extend> GetRoleListExtRepository(RB_Role_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@" 
SELECT group_concat(RoleAuth) AS RoleAuth 
FROM rb_role 
WHERE `Status`=0  AND RoleId IN (SELECT group_concat(RoleAuth) AS RoleAuth FROM rb_employee WHERE empId={0} )
",query.EmpId);
            return Get<RB_Role_Extend>(builder.ToString()).ToList();
        }
    }
}