﻿using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{

    /// <summary>
    /// 活动行程
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Education_ActivityPlan
    {
        /// <summary>
        /// 活动行程id(主键)
        /// </summary>
        public int Id { get; set; }


        /// <summary>
        /// 活动id
        /// </summary>
        public int ActivityId { get; set; }


        /// <summary>
        /// 大标题id
        /// </summary>
        public int TitleId { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int TripSort { get; set; }

        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }


        /// <summary>
        /// 活动时长
        /// </summary>
        public int ActivityDuration { get; set; }


        /// <summary>
        /// 经纬度（逗号分隔）
        /// </summary>
        public string LonLat { get; set; }

        /// <summary>
        /// 位置名称
        /// </summary>
        public string LocationName { get; set; }

        /// <summary>
        /// 标题
        /// </summary>
        public string TripTitle { get; set; }

        /// <summary>
        /// 内容
        /// </summary>
        public string TripContent { get; set; }


        /// <summary>
        /// 图片
        /// </summary>
        public string TripPic { get; set; }


        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public Common.Enum.DateStateEnum Status { get; set; }

    }
}
