﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum.Education;
using VT.FW.DB;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    /// 财务收据实体类
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "EduConnection")]
    public class RB_Receipt_Info
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 相关财务单据ID
        /// </summary>
        public int FinanceId { get; set; }

        /// <summary>
        /// 收据编号
        /// </summary>
        public string ReceiptNo { get; set; }

        /// <summary>
        /// 汇款人
        /// </summary>
        public string Remitter { get; set; }

        /// <summary>
        /// 金额
        /// </summary>
        public decimal Money { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 状态  1已认领  2未认领
        /// </summary>
        public int State { get; set; }

        /// <summary>
        /// 认领码  4位随机数
        /// </summary>
        public int ClaimCode { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 集团编号
        /// </summary>
        public int Group_Id { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// 修改人
        /// </summary>
        public int UpdateBy { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateTime { get; set; }

        /// <summary>
        /// 关联电商用户Id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 电商用户名称
        /// </summary>
        public string UserName { get; set; }

    }
}
