﻿using System;
using VT.FW.DB;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品关联表信息
    /// </summary>
    [Serializable]
	[DB(ConnectionName = "DefaultConnection")]
	public class RB_Goods_Relevance
	{
		/// <summary>
		/// 关联商品主键编号
		/// </summary>
		public int RelevanceId { get; set; }

		/// <summary>
		/// 商品编号
		/// </summary>
		public int GoodsId { get; set; }

		/// <summary>
		/// 关联商品名称
		/// </summary>
		public string RelevanceName { get; set; }

		/// <summary>
		/// 关联商品价格
		/// </summary>
		public decimal RelevancePrice { get; set; }

		/// <summary>
		/// 关联商品状态
		/// </summary>
		public int Status { get; set; }

		/// <summary>
		/// 规格
		/// </summary>
		public string Unit { get; set; }

		/// <summary>
		/// 商户编号
		/// </summary>
		public int TenantId { get; set; }

		/// <summary>
		/// 小程序编号
		/// </summary>
		public int MallBaseId { get; set; }

		/// <summary>
		/// 创建时间
		/// </summary>
		public DateTime CreateDate { get; set; }

		/// <summary>
		/// 关联物品Id
		/// </summary>
		public int RelationId { get; set; }
	}
}
