﻿using Mall.Model.Entity.Reserve;
using System;
using System.Collections.Generic;
using System.Text;
using VT.FW.DB;

namespace Mall.Model.Extend.Reserve
{
    /// <summary>
    ///基础设置扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Reserve_Base_Extend : RB_Reserve_Base
    {
        /// <summary>
        /// 订单状态列表
        /// </summary>
        public List<ReserveStateModel> OrderStateList { get; set; }

        public List<BusinessHoursModel> BusinessHoursList { get; set; }

        /// <summary>
        /// 付款方式
        /// </summary>
        public List<int> PayTypeList { get; set; }
    }


    /// <summary>
    /// 线下服务行业订单状态
    /// </summary>
    public class ReserveStateModel
    {
        /// <summary>
        /// id
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// 状态名称
        /// </summary>
        public string Name { get; set; }
    }

    /// <summary>
    /// 线下服务行业订单状态
    /// </summary>
    public class BusinessHoursModel
    {
        /// <summary>
        /// 营业开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 营业结束时间
        /// </summary>

        public string EndTime { get; set; }

        /// <summary>
        /// 0-否，1-是
        /// </summary>
        public int IsNextDay { get; set; }
    }
}
