﻿using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Education
{
  public  class RB_Education_CouponSelfMotionRepository:BaseRepository<RB_Education_CouponSelfMotion>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Education_CouponSelfMotion); } }

        /// <summary>
        /// 表名称
        /// </summary>
        public string discountCouponTableName { get { return nameof(RB_Education_Coupon); } }
        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_CSelfMotion_Extend> GetSelfMotionPageLis(int pageIndex, int pageSize, out long rowCount, RB_Education_CSelfMotion_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(@$" SELECT a.*,b.`Name` as DiscountCouponName from {TableName} as a LEFT JOIN {discountCouponTableName} as b
on a.DiscountCouponId = b.ID WHERE  a.{nameof(RB_Education_CSelfMotion_Extend.Status)}=0");
            if (query != null)
            {
                // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_CSelfMotion_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_CSelfMotion_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.DiscountCouponId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_CSelfMotion_Extend.DiscountCouponId)}={query.DiscountCouponId}");
                }
            }
            return GetPage<RB_Education_CSelfMotion_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 自动发放优惠券规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Education_CSelfMotion_Extend> GettRepositoryList(RB_Education_CSelfMotion_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Education_CSelfMotion_Extend.Status)}=0 ");
            if (query != null)
            {
                if (query != null)
                {
                    // where += $@" and {nameof(RB_Customer_InfoCreate.CustomerId)}={dmodel.CustomerId}";
                    if (query.TenantId > 0)
                    {
                        builder.Append($" AND {nameof(RB_Education_CSelfMotion_Extend.TenantId)}={query.TenantId}");
                    }
                    if (query.ID > 0)
                    {
                        builder.Append($" AND {nameof(RB_Education_CSelfMotion_Extend.ID)}={query.ID}");
                    }
                    if (query.TenantId > 0)
                    {
                        builder.Append($" AND {nameof(RB_Education_CSelfMotion_Extend.MallBaseId)}={query.MallBaseId}");
                    }
                    if (query.DiscountCouponId > 0)
                    {
                        builder.Append($" AND {nameof(RB_Education_CSelfMotion_Extend.DiscountCouponId)}={query.DiscountCouponId}");
                    }
                }
            }
            return Get<RB_Education_CSelfMotion_Extend>(builder.ToString()).ToList();
        }
    }
}
