﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{

    /// <summary>
    /// 活动参与人员配置仓储层
    /// </summary>
    public class RB_ActivitySurvey_GuestRepository : BaseRepository<RB_ActivitySurvey_Guest>
    {

        /// <summary>
        /// 获取活动参与人员分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_ActivitySurvey_Guest_Extend> GetActivitySurveyGuestPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_ActivitySurvey_Guest_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_ActivitySurvey_Guest AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_ActivitySurvey_Guest_Extend.Status), 0);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_ActivitySurvey_Guest_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_ActivitySurvey_Guest_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.SurveyId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_ActivitySurvey_Guest_Extend.SurveyId), query.SurveyId);
                }
            }
            return GetPage<RB_ActivitySurvey_Guest_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString()).ToList();
        }

        /// <summary>
        /// 获取活动参与人员列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_ActivitySurvey_Guest_Extend> GetActivitySurveyGuestListRepository(RB_ActivitySurvey_Guest_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.* 
FROM RB_ActivitySurvey_Guest AS A
WHERE 1=1
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_ActivitySurvey_Guest_Extend.Status), 0);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_ActivitySurvey_Guest_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_ActivitySurvey_Guest_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.SurveyId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_ActivitySurvey_Guest_Extend.SurveyId), query.SurveyId);
                }
            }
            return Get<RB_ActivitySurvey_Guest_Extend>(builder.ToString()).ToList();
        }
    }
}
