﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 【商载通】 楼宇、载体仓储层
    /// </summary>
    public class RB_Building_CarrierRepository :BaseRepository<RB_Building_Carrier>
    {
        /// <summary>
        /// 【商载通】获取楼宇、载体分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Building_Carrier_Extend> GetBuildingCarrierPageRepository(int pageIndex, int pageSize, out long rowsCount, RB_Building_Carrier_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.ClassName,'') AS CategoryName
FROM RB_Building_Carrier AS A LEFT JOIN rb_brandclass AS B ON A.CategoryId=B.ID
WHERE 1=1 
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.MallBaseId), query.MallBaseId);
                }
                if (query.BuildingCarrierType > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.BuildingCarrierType), query.BuildingCarrierType);
                }
                if (!string.IsNullOrEmpty(query.CarrierName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @CarrierName ", nameof(RB_Building_Carrier_Extend.CarrierName));
                    parameters.Add("@CarrierName", "%" + query.CarrierName.Trim() + "%");
                }
                if (!string.IsNullOrWhiteSpace(query.Developers))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @Developers ", nameof(RB_Building_Carrier_Extend.Developers));
                    parameters.Add("@Developers", "%" + query.Developers.Trim() + "%");
                }
                if (query.OpeningStatus > -1)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.OpeningStatus), query.OpeningStatus);
                }
                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.CategoryId), query.CategoryId);
                }
                if (!string.IsNullOrEmpty(query.QStartDate))
                {
                    builder.AppendFormat(" AND A.{0}>='{1}' ", nameof(RB_Building_Carrier_Extend.OpenTime), query.QStartDate);
                }
                if (!string.IsNullOrEmpty(query.QEndDate))
                {
                    builder.AppendFormat(" AND A.{0}<='{1} 23:59:59' ", nameof(RB_Building_Carrier_Extend.OpenTime), query.QEndDate);
                }
                if (query.MetroNum > 0 || !string.IsNullOrWhiteSpace(query.MetroName))
                {  
                    builder.Append($" AND A.{nameof(RB_Building_Carrier_Extend.ID)} IN (SELECT CarrierId FROM RB_Building_Carriermetro WHERE `Status`=0  ");
                    if (query.MetroNum > 0)
                    {
                        builder.Append($" AND {nameof(RB_Building_Carriermetro.MetroNum)} = {query.MetroNum}");
                    }
                    if (!string.IsNullOrWhiteSpace(query.MetroName))
                    {
                        builder.Append($" AND {nameof(RB_Building_Carriermetro.MetroName)} LIKE @MetroName ");
                        parameters.Add("@MetroName", "%" + query.MetroName.Trim() + "%");
                    }
                    builder.Append(" )");
                }
                if (query.QShopType == 1)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.IsChengDu), 1);
                }
                if (query.QShopType == 2)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.OpenTime), 0);
                }
            }
            builder.AppendFormat(" ORDER BY A.ID DESC ");
            return GetPage<RB_Building_Carrier_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 【商载通】获取楼宇、载体列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Building_Carrier_Extend> GetBuildingCarrierListRepository(RB_Building_Carrier_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT A.*,IFNULL(B.ClassName,'') AS CategoryName
FROM RB_Building_Carrier AS A LEFT JOIN rb_brandclass AS B ON A.CategoryId=B.ID
WHERE 1=1 
");
            builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.CarrierName))
                {
                    builder.AppendFormat(" AND A.{0} LIKE @CarrierName ", nameof(RB_Building_Carrier_Extend.CarrierName));
                    parameters.Add("@CarrierName", "%" + query.CarrierName.Trim() + "%");
                }
                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND A.{0}={1} ", nameof(RB_Building_Carrier_Extend.CategoryId), query.CategoryId);
                }
            }
            return Get<RB_Building_Carrier_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
