﻿using Mall.Common.Plugin;
using Mall.Model.Entity.Reserve;
using Mall.Model.Extend.Reserve;
using Mall.Repository.Reserve;
using Mall.Repository.User;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.Reserve
{
    public class ReserveModule
    {

        /// <summary>
        /// 小程序
        /// </summary>
        private readonly RB_MiniProgramRepository miniProgramRepository = new RB_MiniProgramRepository();
        /// <summary>
        /// 会员信息
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        #region 套餐卡
        private readonly RB_Reserve_CouponRepository discountCouponRepository = new RB_Reserve_CouponRepository();
        private readonly RB_Reserve_CouponProductRepository productRepository = new RB_Reserve_CouponProductRepository();
        private readonly RB_Reserve_MemberUseCouponRepository memberUseCouponRepository = new RB_Reserve_MemberUseCouponRepository();
        private readonly RB_Reserve_MemberCouponRepository memberCouponRepository = new RB_Reserve_MemberCouponRepository();
        private readonly RB_Reserve_CouponSelfMotionMemberRepository selfMotionMemberRepository = new RB_Reserve_CouponSelfMotionMemberRepository();
        private readonly RB_Reserve_CouponSelfMotionRepository selfMotionRepository = new RB_Reserve_CouponSelfMotionRepository();
        #endregion


        #region 服务人员
        private readonly RB_Reserve_ServicePersonalProductRepository servicePersonalProductRepository = new RB_Reserve_ServicePersonalProductRepository();
        private readonly RB_Reserve_ServicePersonalRepository servicePersonalRepository = new RB_Reserve_ServicePersonalRepository();
        private readonly RB_Reserve_ServiceTargetDateRepository serviceTargetDateRepository = new RB_Reserve_ServiceTargetDateRepository();

        #endregion


        #region 基础设置
        private readonly RB_Reserve_BaseRepository reserveBaseRepository = new RB_Reserve_BaseRepository();
        #endregion

        #region 分享服务人员海报
        private readonly RB_Reserve_FenXiaoPosterRepository reserveFenXiaoPosterRepository = new RB_Reserve_FenXiaoPosterRepository();

        #endregion



        #region 分享服务人员海报
        /// <summary>
        /// 根据查询条件获取分销海报实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_Reserve_FenXiaoPoster_Extend GetReserveFenXiaoPosterModule(RB_Reserve_FenXiaoPoster_Extend query)
        {
            return reserveFenXiaoPosterRepository.GetEntityExtRepository(query);
        }

        /// <summary>
        /// 添加修改分销海报
        /// </summary>
        /// <param name="extModel"></param>
        /// <returns></returns>
        public bool SetReserveFenXiaoPosterModule(RB_Reserve_FenXiaoPoster_Extend extModel)
        {
            bool flag;
            if (extModel.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.PosterBgImg),extModel.PosterBgImg},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.IsShowHead),extModel.IsShowHead},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.HeadSize),extModel.HeadSize},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.HeadPaddingTop),extModel.HeadPaddingTop},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.HeadPaddingLeft),extModel.HeadPaddingLeft},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.IsShowNick),extModel.IsShowNick},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.NickSize),extModel.NickSize},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.NickPaddingTop),extModel.NickPaddingTop},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.NickPaddingLeft),extModel.NickPaddingLeft},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.NickColor),extModel.NickColor},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.IsShowQrCode),extModel.IsShowQrCode},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.QrCodeSize),extModel.QrCodeSize},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.QrCodePaddingTop),extModel.QrCodePaddingTop},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.QrCodePaddingLeft),extModel.QrCodePaddingLeft},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.QrCodeType),extModel.QrCodeType},
                    { nameof(RB_Reserve_FenXiaoPoster_Extend.IsOpenReserve),extModel.IsOpenReserve},
                      { nameof(RB_Reserve_FenXiaoPoster_Extend.HeadType),extModel.HeadType},
                };
                flag = reserveFenXiaoPosterRepository.Update(fileds, new WhereHelper(nameof(RB_Reserve_FenXiaoPoster_Extend.Id), extModel.Id));
            }
            else
            {
                int NewId = reserveFenXiaoPosterRepository.Insert(extModel);
                extModel.Id = NewId;
                flag = NewId > 0;
            }
            return flag;
        }
        #endregion


        #region 基础配置
        /// <summary>
        /// 获取基础配置
        /// </summary>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Reserve_Base_Extend GetReserveBaseInfo(int tenantId, int mallBaseId)
        {
            var model = reserveBaseRepository.GetList(new RB_Reserve_Base_Extend() { TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                model = new RB_Reserve_Base_Extend()
                {

                    MallBaseId = mallBaseId,
                    AdvanceMinute = 30,
                    Id = 0,
                    TenantId = tenantId,
                };
            }
            if (model.OrderStateJson == null || model.OrderStateJson == "" || model.OrderStateJson == "[]")
            {
                var list = EnumHelper.GetEnumList(typeof(Common.Enum.Goods.OrderStatusesRerveEnum));
                model.OrderStateList = list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new ReserveStateModel
                {
                    Name = x.Key,
                    Id = Convert.ToInt32(x.Value)
                }).ToList();
            }
            else
            {
                model.OrderStateList = JsonConvert.DeserializeObject<List<ReserveStateModel>>(model.OrderStateJson);
            }
            if (!string.IsNullOrWhiteSpace(model.BusinessHoursJson))
            {
                try
                {
                    model.BusinessHoursList = JsonConvert.DeserializeObject<List<BusinessHoursModel>>(model.BusinessHoursJson);
                }
                catch (Exception)
                {
                    model.BusinessHoursList = new List<BusinessHoursModel>();
                }
            }
            else
            {
                model.BusinessHoursList = new List<BusinessHoursModel>();
            }
            if (!string.IsNullOrWhiteSpace(model.PayTypeJson))
            {
                try
                {
                    model.PayTypeList = JsonConvert.DeserializeObject<List<int>>(model.PayTypeJson);
                }
                catch (Exception)
                {
                    model.PayTypeList = new List<int>();
                }
            }
            else
            {
                model.PayTypeList = new List<int>();
            }
            return model;
        }

        /// <summary>
        /// 保存
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetReserveBaseInfo(RB_Reserve_Base_Extend demodel)
        {
            var model = reserveBaseRepository.GetList(new RB_Reserve_Base_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return reserveBaseRepository.Insert(demodel) > 0;
            }
            else
            {
                model.UpdateBy = demodel.UpdateBy;
                model.AdvanceMinute = demodel.AdvanceMinute;
                model.OrderStateJson = demodel.OrderStateJson;
                model.BusinessHoursJson = demodel.BusinessHoursJson;
                model.PayTypeJson = demodel.PayTypeJson;
                model.OrderStateJson = demodel.OrderStateJson;
                model.UpdateDate = demodel.UpdateDate;
                return reserveBaseRepository.Update(model);
            }
        }
        #endregion


        #region 服务人员信息
        /// <summary>
        /// 套餐卡信息列表 订单数和商品数还未关联
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalPageList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_ServicePersonal_Extend query)
        {
            var list = servicePersonalRepository.GetServicePersonalPageList(pageIndex, pageSize, out rowCount, query);
            //if (list != null && list.Any())
            //{

            //    string Ids = string.Join(",", list.Where(x => x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Category || x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Product).Select(x => x.ID));
            //    var listProduct = servicePersonalProductRepository.GetListByServicePersonalProductIds(query, Ids);
            //    foreach (var item in list)
            //    {
            //        item.ProductList = new List<RB_Reserve_ServicePersonalProduct_Extend>();
            //        item.ProductList = listProduct.Where(x => x.ServiceId == item.ID).ToList();
            //    }
            //}
            return list;
        }



        /// <summary>
        ///小程序端服务人员信息列表  待完善
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalDetailList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_ServicePersonal_Extend query)
        {
            var list = servicePersonalRepository.GetServicePersonalDetailList(pageIndex, pageSize, out rowCount, query);
            return list;
        }



        /// <summary>
        /// 套餐卡信息列表 订单数和商品数还未关联
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetMinServicePersonalList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_ServicePersonal_Extend query)
        {
            var list = servicePersonalRepository.GetMinServicePersonalList(pageIndex, pageSize, out rowCount, query);
            //if (list != null && list.Any())
            //{

            //    string Ids = string.Join(",", list.Where(x => x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Category || x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Product).Select(x => x.ID));
            //    var listProduct = servicePersonalProductRepository.GetListByServicePersonalProductIds(query, Ids);
            //    foreach (var item in list)
            //    {
            //        item.ProductList = new List<RB_Reserve_ServicePersonalProduct_Extend>();
            //        item.ProductList = listProduct.Where(x => x.ServiceId == item.ID).ToList();
            //    }
            //}
            return list;
        }


        /// <summary>
        /// 服务人员信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetServicePersonalList(RB_Reserve_ServicePersonal_Extend query, bool IsSelectDel = false)
        {
            var list = servicePersonalRepository.GetServicePersonalList(query, IsSelectDel);
            if (list != null && list.Any())
            {

                string Ids = string.Join(",", list.Where(x => x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Category || x.ServiceType == Common.Enum.Reserve.ServiceTypeEnum.Product).Select(x => x.ID));
                if (!string.IsNullOrWhiteSpace(Ids))
                {
                    var listProduct = servicePersonalProductRepository.GetListByServicePersonalProductIds(query, Ids);
                    foreach (var item in list)
                    {
                        item.ProductList = new List<RB_Reserve_ServicePersonalProduct_Extend>();
                        item.ProductList = listProduct.Where(x => x.ServiceId == item.ID).ToList();
                    }
                }
            }
            return list;
        }



        /// <summary>
        /// 当天排班服务人员列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetKanBanServicePersonalList(RB_Reserve_ServicePersonal_Extend query)
        {
            var list = servicePersonalRepository.GetKanBanServicePersonalList(query);
            return list;
        }



        /// <summary>
        ///服务人员绩效统计
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServicePersonal_Extend> GetAchievementsList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_ServicePersonal_Extend query)
        {
            return servicePersonalRepository.GetAchievementsList(pageIndex, pageSize, out rowCount, query);
        }


        /// <summary>
        /// 新增/修改服务人员
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateServicePersonal(RB_Reserve_ServicePersonal_Extend model)
        {
            bool flag = false;
            var trans = servicePersonalRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = servicePersonalRepository.Insert(model, trans);
                    if (id > 0 && model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.ServiceType = model.ServiceType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.ServiceId = id);
                        flag = servicePersonalProductRepository.InsertBatch(model.ProductList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = servicePersonalRepository.Update(model, trans);
                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Reserve_ServicePersonalProduct.Status),1},
                             { nameof(RB_Reserve_ServicePersonalProduct.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Reserve_ServicePersonalProduct.ServiceId),FiledValue=id,OperatorEnum=OperatorEnum.Equal}
                        };
                    servicePersonalProductRepository.Update(fileds, whereHelpers, trans);

                    if (model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.ServiceType = model.ServiceType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.ServiceId = id);
                        flag = servicePersonalProductRepository.InsertBatch(model.ProductList, trans);
                    }
                }
                servicePersonalRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateServicePersonal");
                servicePersonalRepository.DBSession.Rollback("AddOrUpdateServicePersonal");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 批量启用/禁用服务人员
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool EnableServicePersonalInfo(List<string> ids, int TeacherStatus, int uid, int mallBaseId)
        {
            var trans = servicePersonalRepository.DbTransaction;
            bool flag = false;
            try
            {
                foreach (var item in ids)
                {
                    if (!string.IsNullOrWhiteSpace(item))
                    {
                        Dictionary<string, object> cols = new Dictionary<string, object>()
                        {
                            { nameof(RB_Reserve_ServicePersonal.ServiceStatus),TeacherStatus},
                            { nameof(RB_Reserve_ServicePersonal.UpdateDate),DateTime.Now},
                        };
                        List<WhereHelper> wheres1 = new List<WhereHelper>() {
                            new WhereHelper(){
                                    FiledName=nameof(RB_Reserve_ServicePersonal.ID),
                                    FiledValue=Convert.ToInt32(item),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Reserve_ServicePersonal.TenantId),
                                    FiledValue=Convert.ToInt32(uid),
                                    OperatorEnum=OperatorEnum.Equal
                            },
                            new WhereHelper(){
                                    FiledName=nameof(RB_Reserve_ServicePersonal.MallBaseId),
                                    FiledValue=Convert.ToInt32(mallBaseId),
                                    OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        flag = servicePersonalRepository.Update(cols, wheres1, trans);
                    }
                }
                servicePersonalRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "EnableServicePersonalInfo");
                servicePersonalRepository.DBSession.Rollback("EnableServicePersonalInfo");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 获取服务人员的工作时间
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_ServiceTargetDate_Extend> GetServiceTargetDateList(RB_Reserve_ServiceTargetDate_Extend dmodel)
        {
            return serviceTargetDateRepository.GetList(dmodel);
        }

        /// <summary>
        /// 服务人员的排班
        /// </summary>
        /// <param name="serviceId"></param>
        /// <param name="list"></param>
        /// <returns></returns>
        public bool AddOrUpdateServiceTargetDate(int serviceId, List<RB_Reserve_ServiceTargetDate_Extend> list)
        {
            try
            {
                #region 修改可预定日期
                var tdlist = serviceTargetDateRepository.GetList(new RB_Reserve_ServiceTargetDate_Extend() { ServiceId = serviceId });
                var tdinsertList = list.Where(x => !tdlist.Select(y => y.Date).Contains(x.Date)).ToList();
                var tddeleteList = tdlist.Where(x => !list.Select(y => y.Date).Contains(x.Date)).ToList();
                foreach (var item in tdinsertList)
                {
                    serviceTargetDateRepository.Insert(new RB_Reserve_ServiceTargetDate()
                    {
                        Id = 0,
                        ServiceId = serviceId,
                        Date = item.Date,
                        IsReserve = 1,
                        ReserveNum = 0
                    });
                }
                if (tdlist != null && tdlist.Any())
                {
                    foreach (var item in tddeleteList)
                    {
                        serviceTargetDateRepository.Delete(item);
                    }
                }

                return true;
                #endregion
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "AddOrUpdateServiceTargetDate");
                return false;
            }
        }



        /// <summary>
        /// 验证可预定日期是否可以修改
        /// </summary>
        /// <param name="goodsIs"></param>
        /// <param name="tdlist"></param>
        /// <returns></returns>
        public string ValidateServiceTargetDate(int serviceId, List<RB_Reserve_ServiceTargetDate_Extend> tdlist)
        {
            var oldtdlist = serviceTargetDateRepository.GetList(new RB_Reserve_ServiceTargetDate_Extend() { ServiceId = serviceId });
            var tddeleteList = oldtdlist.Where(x => !tdlist.Select(y => y.Date).Contains(x.Date)).ToList();
            string msg = "";
            foreach (var item in tddeleteList)
            {
                //看是否有不可预约的 / 有预定人数的
                if (item.IsReserve == 2 || item.ReserveNum > 0)
                {
                    msg += item.Date.Value.ToString("yyyy-MM-dd") + ",";
                }
            }
            if (msg != "")
            {
                msg = msg[..1];
                msg += " 已有订单预定，无法修改当前日期";
            }
            return msg;
        }
        #endregion

        #region 卡包
        /// <summary>
        /// 卡包信息
        /// </summary>
        private readonly RB_Reserve_CardBagRepository reserveCardBagRepository = new RB_Reserve_CardBagRepository();

        /// <summary>
        /// 会员卡包信息
        /// </summary>
        private readonly RB_Reserve_MemberCardBagRepository reserveMemberCardBagRepository = new RB_Reserve_MemberCardBagRepository();
        #endregion




        #region 套餐卡
        /// <summary>
        /// 套餐卡信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetDiscountCouponPageList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_Coupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 套餐卡信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetDiscountCouponList(RB_Reserve_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetDiscountCouponList(query);
            if (list != null && list.Any())
            {

                string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category || x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
                if (!string.IsNullOrWhiteSpace(Ids))
                {
                    var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                    foreach (var item in list)
                    {
                        item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                        item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                    }
                }
            }
            return list;

        }

        /// <summary>
        /// 套餐卡信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetAllDiscountCouponList(RB_Reserve_Coupon_Extend query)
        {
            return discountCouponRepository.GetDiscountCouponList(query);

        }



        /// <summary>
        /// 新增/修改套餐卡
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateDiscountCoupon(RB_Reserve_Coupon_Extend model)
        {
            bool flag = false;
            var trans = discountCouponRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = discountCouponRepository.Insert(model, trans);
                    if (id > 0 && model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.ServiceType = model.UseType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.CouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = discountCouponRepository.Update(model, trans);
                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Reserve_CouponProduct.Status),1},
                             { nameof(RB_Reserve_CouponProduct.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Reserve_CouponProduct.CouponId),FiledValue=id,OperatorEnum=OperatorEnum.Equal}
                        };
                    productRepository.Update(fileds, whereHelpers, trans);

                    if (model.ProductList != null && model.ProductList.Any())
                    {
                        model.ProductList.ForEach(x => x.ServiceType = model.UseType);
                        model.ProductList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.ProductList.ForEach(x => x.TenantId = model.TenantId);
                        model.ProductList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.ProductList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.ProductList.ForEach(x => x.CouponId = id);
                        flag = productRepository.InsertBatch(model.ProductList, trans);
                    }
                }
                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("AddOrUpdateDiscountCoupon");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除套餐卡
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountCoupon(int id, int uid, int mallBaseId)
        {
            var trans = discountCouponRepository.DbTransaction;
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_Coupon.Status),1},
                        { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = discountCouponRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_Coupon.Status),1},
                        { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponProduct.CouponId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponProduct.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponProduct.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                productRepository.Update(cols, wheres);


                discountCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountCoupon");
                discountCouponRepository.DBSession.Rollback("DelDiscountCoupon");
                return false;
            }
            return flag;
        }





        /// <summary>
        /// 删除会员套餐卡
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelMemberCoupon(int id, int uid, int mallBaseId)
        {
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_MemberCoupon.Status),1},
                        { nameof(RB_Reserve_MemberCoupon.Remarks),System.DateTime.Now+"删除"},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_MemberCoupon.Id),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_MemberCoupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_MemberCoupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = memberCouponRepository.Update(cols1, wheres1);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelMemberCoupon");
                return false;
            }
            return flag;
        }



        /// <summary>
        /// 领劵中心
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool UpdatePickupType(int id, int uid, int mallBaseId)
        {
            try
            {
                var model = discountCouponRepository.GetEntity(id);

                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_Coupon.PickupCenter),model.PickupCenter==0?1:0},
                        { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_Coupon.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                return discountCouponRepository.Update(cols1, wheres1);


            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "UpdatePickupType");
                return false;
            }
        }



        /// <summary>
        /// 发放套餐卡
        /// </summary>
        /// <param name="list"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool GrantCoupon(List<RB_Reserve_MemberCoupon_Extend> list, RB_Reserve_Coupon_Extend model)
        {
            var trans = memberCouponRepository.DbTransaction;
            bool flag;
            try
            {
                flag = memberCouponRepository.InsertBatch(list, trans);
                if (model != null && flag)
                {
                    Dictionary<string, object> cols1;
                    if (model.TotalNum != -1)
                    {
                        cols1 = new Dictionary<string, object>()
                        {
                            { nameof(RB_Reserve_Coupon.ReceiveNum),model.ReceiveNum+list.Count()},
                            { nameof(RB_Reserve_Coupon.TotalNum),model.TotalNum - list.Count()},
                            { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                        };
                    }
                    else
                    {
                        cols1 = new Dictionary<string, object>()
                        {
                            { nameof(RB_Reserve_Coupon.ReceiveNum),model.ReceiveNum+list.Count()},

                            { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                        };
                    }
                    List<WhereHelper> wheres1 = new List<WhereHelper>()
                    {
                    new WhereHelper(){
                            FiledName=nameof(RB_Reserve_Coupon.ID),
                            FiledValue=model.ID,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Reserve_Coupon.TenantId),
                            FiledValue=model.TenantId,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Reserve_Coupon.MallBaseId),
                            FiledValue=model.MallBaseId,
                            OperatorEnum=OperatorEnum.Equal
                    }
                    };
                    flag = discountCouponRepository.Update(cols1, wheres1, trans);
                }
                memberCouponRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "GrantCoupon");
                memberCouponRepository.DBSession.Rollback("GrantCoupon");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 根据用户id和商品分类以及商品id获取未使用的套餐卡信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetNoUseCouponList(RB_Reserve_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetNoUseCouponList(query);
            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }

            return list;
        }


        #endregion


        #region 自动发放套餐卡规则
        /// <summary>
        /// 自动发放套餐卡规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CSelfMotion_Extend> GetSelfMotionPageLis(int pageIndex, int pageSize, out long rowCount, RB_Reserve_CSelfMotion_Extend query)
        {
            return selfMotionRepository.GetSelfMotionPageLis(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        /// 自动发放套餐卡规则列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CSelfMotion_Extend> GettRepositoryList(RB_Reserve_CSelfMotion_Extend query)
        {
            var list = selfMotionRepository.GettRepositoryList(query);

            return list;
        }



        /// <summary>
        /// 获取发放套餐卡的人员信息
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CSelfMotionMember_Extend> GetSelfMotionMemberList(RB_Reserve_CSelfMotionMember_Extend query)
        {
            return selfMotionMemberRepository.GetListRepository(query);
        }


        /// <summary>
        /// 新增/修改自动发放套餐卡
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateSelfMotion(RB_Reserve_CSelfMotion_Extend model)
        {
            bool flag = false;
            var trans = selfMotionRepository.DbTransaction;
            try
            {
                int id = 0;
                if (model.ID == 0)
                {
                    id = selfMotionRepository.Insert(model, trans);
                    if (id > 0 && model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                    flag = id > 0;
                }
                else
                {
                    id = model.ID;
                    flag = selfMotionRepository.Update(model, trans);

                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                         {
                            { nameof(RB_Reserve_CouponSelfMotionMember.Status),1},
                             { nameof(RB_Reserve_CouponSelfMotionMember.UpdateDate),model.UpdateDate},
                          };
                    IList<WhereHelper> whereHelpers = new List<WhereHelper>()
                        {
                            new WhereHelper (){ FiledName=nameof(RB_Reserve_CouponSelfMotionMember.SelfMotionId),FiledValue=model.ID,OperatorEnum=OperatorEnum.Equal},
                             new WhereHelper (){ FiledName=nameof(RB_Reserve_CouponSelfMotionMember.MallBaseId),FiledValue=model.MallBaseId,OperatorEnum=OperatorEnum.Equal},
                              new WhereHelper (){ FiledName=nameof(RB_Reserve_CouponSelfMotionMember.TenantId),FiledValue=model.TenantId,OperatorEnum=OperatorEnum.Equal}
                        };
                    selfMotionMemberRepository.Update(fileds, whereHelpers, trans);


                    if (model.UserList != null && model.UserList.Any())
                    {
                        model.UserList.ForEach(x => x.MallBaseId = model.MallBaseId);
                        model.UserList.ForEach(x => x.TenantId = model.TenantId);
                        model.UserList.ForEach(x => x.CreateDate = model.CreateDate);
                        model.UserList.ForEach(x => x.UpdateDate = model.UpdateDate);
                        model.UserList.ForEach(x => x.SelfMotionId = id);
                        flag = selfMotionMemberRepository.InsertBatch(model.UserList, trans);
                    }
                }
                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateSelfMotion");
                selfMotionRepository.DBSession.Rollback("AddOrUpdateSelfMotion");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 删除自动发放套餐卡
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelDiscountSelfMotion(int id, int uid, int mallBaseId)
        {
            var trans = selfMotionRepository.DbTransaction;
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_CouponSelfMotion.Status),1},
                        { nameof(RB_Reserve_CouponSelfMotion.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotion.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotion.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotion.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = selfMotionRepository.Update(cols1, wheres1);

                Dictionary<string, object> cols = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_CouponSelfMotionMember.Status),1},
                        { nameof(RB_Reserve_CouponSelfMotionMember.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotionMember.SelfMotionId),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotionMember.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CouponSelfMotionMember.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                selfMotionMemberRepository.Update(cols, wheres);


                selfMotionRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelDiscountSelfMotion");
                selfMotionRepository.DBSession.Rollback("DelDiscountSelfMotion");
                return false;
            }
            return flag;
        }


        #endregion


        #region 会员套餐卡
        /// <summary>
        /// 我的套餐卡
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetMemberDisCouponList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetMemberDisCouponList(pageIndex, pageSize, out rowCount, query);
            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            return list;
        }
        #endregion



        #region 网课小程序个人中心-学习卡中心

        /// <summary>
        /// 领劵中心套餐卡
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_Coupon_Extend> GetAllCouponList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_Coupon_Extend query)
        {
            var list = discountCouponRepository.GetAllCouponList(pageIndex, pageSize, out rowCount, query);

            //获取特定商品或者分类的数据
            string Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Category;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Category))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            Ids = string.Join(",", list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product).Select(x => x.ID));
            if (!string.IsNullOrWhiteSpace(Ids))
            {
                query.UseType = Common.Enum.MarketingCenter.UseTypeEnum.Product;
                var listProduct = productRepository.GetListByDiscountCouponIds(query, Ids);
                foreach (var item in list.Where(x => x.UseType == Common.Enum.MarketingCenter.UseTypeEnum.Product))
                {
                    item.ProductList = new List<RB_Reserve_CouponProduct_Extend>();
                    item.ProductList = listProduct.Where(x => x.CouponId == item.ID).ToList();
                }
            }
            return list;
        }



        /// <summary>
        /// 会员套餐卡
        /// </summary>
        /// <returns></returns>
        public List<RB_Reserve_MemberCoupon_Extend> GetMemberDiscountCouponList(RB_Reserve_MemberCoupon_Extend query)
        {
            return memberCouponRepository.GetList(query);
        }
        #endregion


        #region 自动发放给会员套餐卡
        /// <summary>
        /// 自动给会员发放套餐卡
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="getType">1-分享，2-购买并付款，3-新人领券</param>
        /// <returns></returns>
        public RB_Reserve_Coupon_Extend AutoEducationCoupon(RB_Reserve_Coupon_Extend model)
        {
            RB_Reserve_Coupon_Extend resultModel = new RB_Reserve_Coupon_Extend();
            //先查找会员是否存在
            var memberUserModel = member_UserRepository.GetEntity(model.UserId);
            if (memberUserModel == null)
            {
                return resultModel;
            }
            //根据发放类型获取对应的套餐卡信息
            model.SmallShopId = memberUserModel.SmallShopId;
            if (model.TriggerType == 4)
            {
                model.RegisterDate = memberUserModel.CreateDate;
            }
            var couponList = discountCouponRepository.GetSelfmotionCouponList(model);
            if (couponList != null && couponList.Any(x => x.TotalNum == -1 || x.TotalNum > 0))//存在满足条件的套餐卡可以发放
            {
                bool isReceive = false;
                //查询已发放的套餐卡信息
                var memberCouponList = memberCouponRepository.GetAutoMemberCouponPageList(new RB_Reserve_MemberCoupon_Extend { UserId = model.UserId, GetType = model.TriggerType, TenantId = model.TenantId, MallBaseId = model.MallBaseId });
                foreach (var item in couponList.Where(x => x.TotalNum == -1 || x.TotalNum > 0))//判断当前套餐卡是否已超过领取数
                {
                    int membercouponCoun = memberCouponList.Where(x => x.CouponId == item.ID).Count();
                    if (!isReceive && membercouponCoun < item.GrantNum)//此次没有领取，并且当前套餐卡没有超过领取数量
                    {
                        var trans = memberCouponRepository.DbTransaction;
                        try
                        {
                            RB_Reserve_MemberCoupon nowMemberCoupon = new RB_Reserve_MemberCoupon
                            {
                                Id = 0,
                                TenantId = item.TenantId,
                                MallBaseId = item.MallBaseId,
                                Status = 0,
                                CreateDate = System.DateTime.Now,
                                UserId = model.UserId,
                                Description = item.TriggerType == 1 ? "分享自动发放套餐卡" : (item.TriggerType == 2 ? "购买并付款自动发放套餐卡" : (item.TriggerType == 3 ? "新人领劵自动发放套餐卡" : "新人购买并付款自动发放套餐卡")),
                                Remarks = item.TriggerType == 1 ? "分享" : (item.TriggerType == 2 ? "购买并付款" : (item.TriggerType == 3 ? "新人领劵" : "新人购买并付款")),
                                CouponId = item.ID,
                                StartDate = item.IndateType == Common.Enum.MarketingCenter.IndateTypeEnum.DayHorizon ? System.DateTime.Now : item.StartDate,
                                EndDate = item.IndateType == Common.Enum.MarketingCenter.IndateTypeEnum.DayHorizon ? System.DateTime.Now.AddDays(item.IndateDay) : item.EndDate,
                                GetType = item.TriggerType,
                                UseType = item.UseType,
                                Name = item.Name,
                                HeXiao = item.HeXiao,
                                UseHeXiao = 0
                            };

                            isReceive = memberCouponRepository.Insert(nowMemberCoupon, trans) > 0;
                            if (isReceive)//更新当前套餐卡的领取数量
                            {
                                Dictionary<string, object> cols1;

                                if (item.TotalNum != -1)
                                {
                                    cols1 = new Dictionary<string, object>()
                                    {
                                        { nameof(RB_Reserve_Coupon.ReceiveNum),item.ReceiveNum+1},
                                        { nameof(RB_Reserve_Coupon.TotalNum),item.TotalNum - 1},
                                        { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                                    };
                                }
                                else
                                {
                                    cols1 = new Dictionary<string, object>()
                                    {
                                        { nameof(RB_Reserve_Coupon.ReceiveNum),item.ReceiveNum+1},
                                        { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                                    };
                                }
                                List<WhereHelper> wheres1 = new List<WhereHelper>()
                                {
                                    new WhereHelper(){
                                            FiledName=nameof(RB_Reserve_Coupon.ID),
                                            FiledValue=item.ID,
                                            OperatorEnum=OperatorEnum.Equal
                                    },
                                    new WhereHelper(){
                                            FiledName=nameof(RB_Reserve_Coupon.TenantId),
                                            FiledValue=item.TenantId,
                                            OperatorEnum=OperatorEnum.Equal
                                    },
                                    new WhereHelper(){
                                            FiledName=nameof(RB_Reserve_Coupon.MallBaseId),
                                            FiledValue=item.MallBaseId,
                                            OperatorEnum=OperatorEnum.Equal
                                    }
                                };
                                discountCouponRepository.Update(cols1, wheres1, trans);
                            }
                            memberCouponRepository.DBSession.Commit();
                            return item;
                        }
                        catch (Exception ex)
                        {
                            LogHelper.Write(ex, "AutoEducationCoupon");
                            memberCouponRepository.DBSession.Rollback("AutoEducationCoupon");
                            return resultModel;
                        }
                    }
                }
            }
            return resultModel;
        }
        #endregion


        #region 卡包
        /// <summary>
        /// 卡包信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CardBag_Extend> GetCardBagPageList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_CardBag_Extend query)
        {
            return reserveCardBagRepository.GetCardBagPageList(pageIndex, pageSize, out rowCount, query);
        }

        /// <summary>
        ///卡包信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CardBag_Extend> GetCardBagList(RB_Reserve_CardBag_Extend query, bool IsSelectDel = false)
        {
            var list = reserveCardBagRepository.GetCardBagList(query, IsSelectDel);

            return list;

        }

        /// <summary>
        /// 卡包信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CardBag_Extend> GetAllCardBagList(RB_Reserve_CardBag_Extend query)
        {
            return reserveCardBagRepository.GetCardBagList(query);

        }



        /// <summary>
        /// 新增/修改卡包
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddOrUpdateCardBag(RB_Reserve_CardBag_Extend model)
        {
            try
            {
                if (model.ID == 0)
                {
                    return reserveCardBagRepository.Insert(model) > 0;
                }
                else
                {
                    return reserveCardBagRepository.Update(model);
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "AddOrUpdateCardBag");
                return false;
            }
        }

        /// <summary>
        /// 删除卡包
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelCardBag(int id, int uid, int mallBaseId)
        {
            bool flag;
            try
            {
                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_CardBag.Status),1},
                        { nameof(RB_Reserve_CardBag.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CardBag.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CardBag.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CardBag.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                flag = reserveCardBagRepository.Update(cols1, wheres1);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "DelCardBag");
                return false;
            }
            return flag;
        }

        /// <summary>
        /// 领劵中心
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool UpdateCardBagPickupType(int id, int uid, int mallBaseId)
        {
            try
            {
                var model = reserveCardBagRepository.GetEntity(id);

                Dictionary<string, object> cols1 = new Dictionary<string, object>()
                    {
                        { nameof(RB_Reserve_CardBag.PickupCenter),model.PickupCenter==0?1:0},
                        { nameof(RB_Reserve_CardBag.UpdateDate),DateTime.Now},
                    };
                List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CardBag.ID),
                        FiledValue=id,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CardBag.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Reserve_CardBag.MallBaseId),
                        FiledValue=Convert.ToInt32(mallBaseId),
                        OperatorEnum=OperatorEnum.Equal
                }
                };
                return reserveCardBagRepository.Update(cols1, wheres1);


            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "UpdateCardBagPickupType");
                return false;
            }
        }

        #endregion



        #region 网课小程序个人中心-卡包中心

        /// <summary>
        /// 领劵中心卡券
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CardBag_Extend> GetAllCardBagList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_CardBag_Extend query)
        {
            var list = reserveCardBagRepository.GetAllCardBagList(pageIndex, pageSize, out rowCount, query);

            return list;
        }



        /// <summary>
        /// 会员套餐卡
        /// </summary>
        /// <returns></returns>
        public List<RB_Reserve_MemberCardBag_Extend> GetMemberCarBagList(RB_Reserve_MemberCardBag_Extend query)
        {
            return reserveMemberCardBagRepository.GetList(query);
        }


        /// <summary>
        /// 发放套餐卡
        /// </summary>
        /// <param name="list"></param>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool GrantCardBag(List<RB_Reserve_MemberCardBag_Extend> list, RB_Reserve_CardBag_Extend model)
        {
            var trans = reserveMemberCardBagRepository.DbTransaction;
            bool flag;
            try
            {
                flag = reserveMemberCardBagRepository.InsertBatch(list, trans);
                if (model != null && flag)
                {
                    Dictionary<string, object> cols1 = new Dictionary<string, object>()
                        {
                            { nameof(RB_Reserve_Coupon.UpdateDate),DateTime.Now},
                        };
                    List<WhereHelper> wheres1 = new List<WhereHelper>()
                    {
                    new WhereHelper(){
                            FiledName=nameof(RB_Reserve_CardBag.ID),
                            FiledValue=model.ID,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Reserve_CardBag.TenantId),
                            FiledValue=model.TenantId,
                            OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                            FiledName=nameof(RB_Reserve_CardBag.MallBaseId),
                            FiledValue=model.MallBaseId,
                            OperatorEnum=OperatorEnum.Equal
                    }
                    };
                    flag = reserveCardBagRepository.Update(cols1, wheres1, trans);
                }
                reserveMemberCardBagRepository.DBSession.Commit();
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "GrantCardBag");
                reserveMemberCardBagRepository.DBSession.Rollback("GrantCardBag");
                return false;
            }
            return flag;
        }


        /// <summary>
        /// 我的套餐卡
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Reserve_CardBag_Extend> GetMemberCardBagList(int pageIndex, int pageSize, out long rowCount, RB_Reserve_CardBag_Extend query)
        {
            var list = reserveCardBagRepository.GetMemberCardBagList(pageIndex, pageSize, out rowCount, query);
           
            return list;
        }
        #endregion
    }
}
