﻿using Mall.Common.Plugin;
using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 榜单处理类
    /// </summary>
    public class FirstShopListModule
    {
        /// <summary>
        /// 榜单
        /// </summary>
        private readonly RB_FirstShop_ListRepository firstShop_ListRepository = new RB_FirstShop_ListRepository();
        /// <summary>
        /// 报名
        /// </summary>
        private readonly RB_FirstShop_ListEnrollRepository firstShop_ListEnrollRepository = new RB_FirstShop_ListEnrollRepository();
        /// <summary>
        /// 用户
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();

        /// <summary>
        /// 获取榜单分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_FirstShop_List_Extend> GetFirstShopListPageList(int pageIndex, int pageSize, out long rowsCount, RB_FirstShop_List_Extend query)
        {
            var list = firstShop_ListRepository.GetPageList(pageIndex, pageSize, out rowsCount, query);
            if (list.Any()) {
                foreach (var item in list) {

                    if (item.ListState == Common.Enum.TradePavilion.ListStateEnum.Enroll && item.DeadlineDate <= DateTime.Now)
                    {
                        item.ListState = Common.Enum.TradePavilion.ListStateEnum.Rating;
                    }
                    item.ObjectTypeList = new List<string>();
                    if (!string.IsNullOrEmpty(item.ObjectTypeIds)) {
                        List<int> OIdList = JsonHelper.DeserializeObject<List<int>>("[" + item.ObjectTypeIds + "]");
                        foreach (var qitem in OIdList)
                        {
                            item.ObjectTypeList.Add(((Common.Enum.TradePavilion.ListObjectTypeEnum)qitem).GetEnumName());
                        }
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取榜单详情
        /// </summary>
        /// <param name="wishId"></param>
        /// <returns></returns>
        public RB_FirstShop_List_Extend GetFirstShopListInfo(int listId)
        {
            return firstShop_ListRepository.GetEntity<RB_FirstShop_List_Extend>(listId);
        }

        /// <summary>
        /// 新增修改榜单
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public string SetFirstShopListInfo(RB_FirstShop_List_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                var oldModel = firstShop_ListRepository.GetEntity(demodel.Id);
                if (oldModel == null || oldModel.Status == 1 || oldModel.ListState == Common.Enum.TradePavilion.ListStateEnum.Cancel || oldModel.ListState == Common.Enum.TradePavilion.ListStateEnum.Confirmed) {
                    return "绑单状态不正确";
                }

                //修改
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_FirstShop_List_Extend.ListType),demodel.ListType },
                    { nameof(RB_FirstShop_List_Extend.ObjectTypeIds),demodel.ObjectTypeIds },
                    { nameof(RB_FirstShop_List_Extend.Sponsor),demodel.Sponsor },
                    { nameof(RB_FirstShop_List_Extend.ListName),demodel.ListName },
                    { nameof(RB_FirstShop_List_Extend.CoverImage),demodel.CoverImage },
                    { nameof(RB_FirstShop_List_Extend.DeadlineDate),demodel.DeadlineDate },
                    { nameof(RB_FirstShop_List_Extend.StartDate),demodel.StartDate },
                    { nameof(RB_FirstShop_List_Extend.Content),demodel.Content },
                    { nameof(RB_FirstShop_List_Extend.EnableRank),demodel.EnableRank },
                    { nameof(RB_FirstShop_List_Extend.PrizeNum),demodel.PrizeNum },
                    { nameof(RB_FirstShop_List_Extend.UpdateBy),demodel.UpdateBy },
                    { nameof(RB_FirstShop_List_Extend.UpdateDate),demodel.UpdateDate }
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_FirstShop_List_Extend.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                bool flag = firstShop_ListRepository.Update(keyValues, wheres);
                return flag ? "" : "修改失败,请联系管理员";
            }
            else {
                //新增
                bool flag = firstShop_ListRepository.Insert(demodel) > 0;
                return flag ? "" : "新增失败，请联系管理员";
            }
        }

        /// <summary>
        /// 取消榜单
        /// </summary>
        /// <param name="listId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public string DelFirstShopListInfo(int listId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_FirstShop_List_Extend.ListState), Common.Enum.TradePavilion.ListStateEnum.Cancel}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_FirstShop_List_Extend.Id),
                      FiledValue=listId,
                       OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                     FiledName= nameof(RB_FirstShop_List_Extend.MallBaseId),
                      FiledValue= mallBaseId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = firstShop_ListRepository.Update(keyValues, wheres);
            return flag ? "" : "取消失败";
        }
    }
}
