﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.API
{
    /// <summary>
    /// Api返回结果
    /// </summary>
    public class ApiResult
    {
        /// <summary>
        /// 状态码
        /// </summary>
        public int resultCode { get; set; }

        /// <summary>
        /// 提示信息
        /// </summary>
        public string message { get; set; }

        /// <summary>
        /// 返回数据
        /// </summary>
        public object data { get; set; }

        /// <summary>
        /// 请求成功
        /// </summary>
        /// <param name="message">提示信息</param>
        /// <param name="data">返回数据</param>
        /// <returns></returns>
        public static ApiResult Success(string message = null, object data = null)
        {
            return new ApiResult() { resultCode = (int)ResultCode.Success, message = message ?? "操作成功！", data = data };
        }


        /// <summary>
        /// 请求失败
        /// </summary>
        /// <param name="message">提示信息</param>
        /// <param name="data">返回数据</param>
        /// <returns></returns>
        public static ApiResult Failed(string message = null, object data = null)
        {
            return new ApiResult { resultCode = (int)ResultCode.Fail, message = message ?? "操作失败！", data = data };
        }

        /// <summary>
        /// 服务器返回提示信息，询问用户是否确认操作(事例:已经存在此领队/导游的档期数据，是否继续保存数据?)
        /// </summary>
        /// <param name="message"></param>
        /// <param name="data"></param>
        /// <returns></returns>
        public static ApiResult Tip(string message = null, object data = null)
        {
            return new ApiResult { resultCode = (int)ResultCode.Tip, message = message ?? "", data = data };
        }

        /// <summary>
        /// 参数丢失
        /// </summary>
        /// <param name="message"></param>
        /// <param name="data"></param>
        /// <returns></returns>
        public static ApiResult ParamIsNull(string message = null, object data = null)
        {
            return new ApiResult { resultCode = (int)ResultCode.ParamIsNull, message = message ?? "参数为空！", data = data };
        }
    }
    /// <summary>
    /// 分页返回数据
    /// </summary>
    public class ResultPageModel
    {
        /// <summary>
        /// 当前页
        /// </summary>
        public int pageIndex { get; set; }
        /// <summary>
        /// 分页大小
        /// </summary>
        public int pageSize { get; set; }
        /// <summary>
        /// 总条数
        /// </summary>
        public int count { get; set; }
        /// <summary>
        /// 分页数
        /// </summary>
        public int pageCount
        {
            get
            {
                if (pageSize != 0 && count != 0)
                {
                    if (count % pageSize == 0)
                    {
                        return Convert.ToInt32(count) / pageSize;
                    }
                    else
                    {
                        return Convert.ToInt32(count) / pageSize + 1;
                    }
                }
                else
                {
                    return 0;
                }

            }
        }
        /// <summary>
        /// 分页数据
        /// </summary>
        public object pageData { get; set; }


    }
    /// <summary>
    /// 文件上传
    /// </summary>
    public class ResultFileModel
    {
        /// <summary>
        /// 文件全路径
        /// </summary>
        public string FullFilePath { get; set; }
        /// <summary>
        /// 文件路径
        /// </summary>
        public string FilePath { get; set; }
        /// <summary>
        /// 文件大小
        /// </summary>
        public int Size { get; set; }
        /// <summary>
        /// 图片宽度
        /// </summary>
        public int Width { get; set; }
        /// <summary>
        /// 图片高度
        /// </summary>
        public int Heigth { get; set; }
        /// <summary>
        /// 文件名
        /// </summary>
        public string FileName { get; set; }
        /// <summary>
        /// 文件后缀
        /// </summary>
        public string Ext { get; set; }
    }
}