﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Test.Model
{
    /// <summary>
    /// 页面实体类
    /// </summary>
    public class PageData
    { 
        /// <summary>
        /// 页面编号
        /// </summary>
       public int id { get; set; }

        /// <summary>
        /// 页面标题
        /// </summary>
        public string title { get; set;}

        /// <summary>
        /// 是否显示导航
        /// </summary>
        public int show_navs { get; set; }

        /// <summary>
        /// 是否启用
        /// </summary>
        public int is_disable { get; set; }

        /// <summary>
        /// 是否首页
        /// </summary>
        public int is_home_page { get; set; }

        /// <summary>
        /// 导航模板
        /// </summary>
        public List<navsData> navs { get; set; }
    }

    /// <summary>
    /// 导航数据
    /// </summary>
    public class navsData 
    { 
        /// <summary>
        /// 导航编号
        /// </summary>
      // public int navs { get; set; }


        /// <summary>
        /// 导航编号
        /// </summary>
        public int navs_id { get; set; }

        /// <summary>
        /// 模板名称
        /// </summary>
        public string template { get; set; }

        /// <summary>
        /// 模板编号
        /// </summary>
        public int template_id { get; set; }
    }

    /// <summary>
    /// 模板实体类
    /// </summary>
    public class TemplateData
    {
        /// <summary>
        /// 模板编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商城编号
        /// </summary>
        public int mall_id { get; set; }

        /// <summary>
        /// 模板名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 模板数据
        /// </summary>
        public string data { get; set; }
    }

    /// <summary>
    /// 分类实体
    /// </summary>
    public class Category
    {
        /// <summary>
        /// 分类编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 商城Id
        /// </summary>
        public int mall_id { get; set; }

        public int mch_id { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 1-图片，2-视频
        /// </summary>
        public int type { get; set; }

        public int is_recycle { get; set; }
    }


    /// <summary>
    /// 分类图片实体
    /// </summary>
    public class CategoryImg
    {
        /// <summary>
        /// 主键编号
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// storage_id
        /// </summary>
        public int storage_id { get; set; }

        /// <summary>
        /// 分类编号
        /// </summary>
        public int attachment_group_id { get; set; }

        /// <summary>
        /// 分类名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 图片大小
        /// </summary>
        public int size { get; set; }

        /// <summary>
        /// 图片地址
        /// </summary>
        public string url { get; set; }

        /// <summary>
        /// 缩略图地址
        /// </summary>
        public string thumb_url { get; set; }

        /// <summary>
        /// 1-图片，2-视频
        /// </summary>
        public int type { get; set; }
    }

}
