﻿using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 
    /// </summary>
    public class RB_Visit_LogRepository : BaseRepository<RB_Visit_Log>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Visit_Log); } }


        /// <summary>
        /// 获取访问记录信息
        /// </summary>
        /// <param name="query"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <returns></returns>
        public List<RB_Visit_Log> GetList(RB_Visit_Log query, string startTime, string endTime)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE 1=1");
            if (query != null)
            {

                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Prize_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND {nameof(RB_Prize_Extend.MallBaseId)}={query.MallBaseId}");
                }


                if (!string.IsNullOrWhiteSpace(startTime))
                {
                    builder.Append($" AND {nameof(RB_Prize_Extend.CreateDate)}={query.Id}");
                }
                if (!string.IsNullOrWhiteSpace(endTime))
                {
                    builder.Append($" AND {nameof(RB_Prize_Extend.CreateDate)}={query.Id}");
                }


            }
            builder.Append($" order by Id desc");
            return Get<RB_Visit_Log>(builder.ToString()).ToList();
        }
    }
}
