﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Assess;
using Mall.Model.Extend.Assess;
using System.Linq;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Assess
{
    /// <summary>
    /// 估价品牌仓储层
    /// </summary>
    public class RB_Assess_BrandRepository : BaseRepository<RB_Assess_Brand>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Assess_Brand_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Assess_Brand_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1 and e.{nameof(RB_Assess_Brand_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0) {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.CategoryId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.CategoryId)} ={dmodel.CategoryId}";
            }
            if (dmodel.IsHot > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.IsHot)} ={dmodel.IsHot}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.Name)} like @Name";
                parameters.Add("Name", "%" + dmodel.Name + "%");
            }

            string sql = $@"
select e.*,IFNULL(B.`Name`,'') AS CategoryName
from RB_Assess_Brand e LEFT JOIN rb_assess_category AS B ON e.CategoryId=B.Id
where {where} order by e.Id desc";
            return GetPage<RB_Assess_Brand_Extend>(pageIndex, pageSize, out rowCount, sql, parameters).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Assess_Brand_Extend> GetList(RB_Assess_Brand_Extend dmodel)
        {
            var parameters = new DynamicParameters();
            string where = $" 1=1 and e.{nameof(RB_Assess_Brand_Extend.Status)}=0 ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.CategoryId > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.CategoryId)} ={dmodel.CategoryId}";
            }
            if (dmodel.IsHot > 0)
            {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.IsHot)} ={dmodel.IsHot}";
            }
            if (!string.IsNullOrEmpty(dmodel.Name))
            {
                where += $@" and e.{nameof(RB_Assess_Brand_Extend.Name)} like @Name";
                parameters.Add("Name", "%" + dmodel.Name + "%");
            }

            string sql = $@"select * from RB_Assess_Brand e where {where} order by e.Id desc";
            return Get<RB_Assess_Brand_Extend>(sql).ToList();
        }
    }
}
