﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 分享分类仓储层
    /// </summary>
    public class RB_Share_CategoryRepository : BaseRepository<RB_Share_Category>
    {
        /// <summary>
        /// 获取分享分类分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowsCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Category_Extend> GetShareCategoryPageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Share_Category_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_share_category
WHERE 1=1 AND Status=0
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Category_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Category_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Share_Category_Extend.Name)} like '%{query.Name}%'");
                }
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Category_Extend.Id)}={query.Id}");
                }
                if (!string.IsNullOrWhiteSpace(query.QCateIds))
                {
                    builder.AppendFormat(" AND {0} IN ({1}) ", nameof(RB_Share_Category_Extend.Id), query.QCateIds);
                }
            }
            return GetPage<RB_Share_Category_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 获取分享分类列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Share_Category_Extend> GetShareCategoryListRepository(RB_Share_Category_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM rb_share_category
WHERE 1=1 AND Status=0
");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Category_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Category_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Share_Category_Extend.Name)} like '%{query.Name}%'");
                }
                if (query.Id > 0)
                {
                    builder.Append($" AND {nameof(RB_Share_Category_Extend.Id)}={query.Id}");
                }
                if (!string.IsNullOrWhiteSpace(query.QCateIds))
                {
                    builder.AppendFormat(" AND {0} IN ({1}) ", nameof(RB_Share_Category_Extend.Id),query.QCateIds);
                }
            }
            return Get<RB_Share_Category_Extend>(builder.ToString()).ToList();
        }

        /// <summary>
        /// 根据上级编号获取所有子级分类
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Share_Category_Extend> GetChildCategoryListRepository(RB_Share_Category_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT tabA.* 
FROM (SELECT * FROM rb_share_category WHERE `Status`=0 AND ParentId>0) tabA,
     (SELECT @pid := '{0}') pd 
WHERE FIND_IN_SET(ParentId, @pid) > 0  AND @pid := concat(@pid, ',', id) 
UNION
SELECT * 
FROM rb_share_category 
WHERE `Status`=0 AND FIND_IN_SET(Id,@pid) > 0 ",query.QCateIds);
            return Get<RB_Share_Category_Extend>(builder.ToString()).ToList();
        }
    }
}
