﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Common.Enum.MarketingCenter
{
    /// <summary>
    /// 触发事件，1-分享，2-购买并付款，3-新人领券，4-新人购买并付款
    /// </summary>
    public enum TriggerTypeEnum
    {
        /// <summary>
        /// 分享
        /// </summary>
        [EnumField("分享")]
        Share = 1,
        /// <summary>
        /// 购买并付款
        /// </summary>
        [EnumField("购买并付款")]
        BuyAndPay = 2,
        /// <summary>
        /// 新人领券
        /// </summary>
        [EnumField("新人领券")]
        NewMemer = 3,
        /// <summary>
        /// 新人购买并付款
        /// </summary>
        [EnumField("新人购买并付款")]
        NewMemerBuyAndPay = 4

    }
}
