﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 模板市场仓储类
    /// </summary>
    public class RB_Template_MarketRepository: RepositoryBase<RB_Template_Market>
    {
        /// <summary>
        /// 模板市场分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Template_Market_Extend> GetTemplateMarketPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Template_Market_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Template_Market WHERE Status=0 ");
            if (query != null)
            {
                if (query.Name != null && !string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Template_Market_Extend.Name)} like '%{query.Name.Trim()}%'");
                }
                if (query.IsShow >= 0)
                {
                    builder.AppendFormat(" AND {0}={1}", nameof(RB_Template_Market_Extend.IsShow),query.IsShow);
                }
                if (query.IsUse >= 0)
                {
                    builder.AppendFormat(" AND {0}={1}", nameof(RB_Template_Market_Extend.IsUse), query.IsUse);
                }
            }
            return GetPage<RB_Template_Market_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 模板市场列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Template_Market_Extend> GetTemplateMarketListRepository(RB_Template_Market_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Template_Market WHERE Status=0 ");
            if (query != null)
            {
                if (query.Name != null && !string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Template_Market_Extend.Name)} like '%{query.Name.Trim()}%'");
                }
            }
            return Get<RB_Template_Market_Extend>(builder.ToString()).ToList();
        }
    }
}
