﻿using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.Linq;

namespace Mall.Common.Plugin
{
    /// <summary>
    /// Json帮助类
    /// </summary>
    public static class JsonHelper
    {
        /// <summary>
        /// 获取String
        /// </summary>
        /// <param name="jObject"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetStringValue(this JObject jObject, string key)
        {
            return jObject[key] == null ? "" : jObject[key].ToString();
        }

        /// <summary>
        /// 获取Int
        /// </summary>
        /// <param name="jObject"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static int GetInt(this JObject jObject, string key)
        {
            Int32.TryParse(jObject[key] == null ? "" : jObject[key].ToString(), out int result);
            return result;
        }

        /// <summary>
        /// 获取Int
        /// </summary>
        /// <param name="jObject"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static long GetLong(this JObject jObject, string key)
        {
            long.TryParse(jObject[key] == null ? "" : jObject[key].ToString(), out long result);
            return result;
        }

        /// <summary>
        /// 获取当前页
        /// </summary>
        /// <param name="jObject"></param>
        /// <param name="key"></param>
        /// <param name="pageIndex">当前页</param>
        /// <returns></returns>
        public static int GetPageIndex(this JObject jObject, string key, int pageIndex = 1)
        {
            Int32.TryParse(jObject[key] == null ? "" : jObject[key].ToString(), out int result);
            return result == 0 ? pageIndex : result;
        }
        /// <summary>
        /// 获取分页大小
        /// </summary>
        /// <param name="jObject"></param>
        /// <param name="key"></param>
        /// <param name="pageSize">当前页</param>
        /// <returns></returns>
        public static int GetPageSize(this JObject jObject, string key, int pageSize = 15)
        {
            Int32.TryParse(jObject[key] == null ? "" : jObject[key].ToString(), out int result);
            return result == 0 ? pageSize : result;
        }
        /// <summary>
        /// 获取如果值为空，则取默认值
        /// </summary>
        /// <param name="jObject"></param>
        /// <param name="key"></param>
        /// <param name="defalutvalue"></param>
        /// <returns></returns>
        public static int GetInt(this JObject jObject, string key, int defalutvalue)
        {
            int result;
            if (jObject[key] == null)
            {
                result = defalutvalue;
            }
            else
            {
                Int32.TryParse(jObject[key] == null ? "" : jObject[key].ToString(), out result);
            }
            return result;
        }
        /// <summary>
        /// 获取Decimal
        /// </summary>
        /// <param name="jObject"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static decimal GetDecimal(this JObject jObject, string key)
        {
            decimal.TryParse(jObject[key] == null ? "" : jObject[key].ToString(), out decimal result);
            return result;
        }

        /// <summary>
        /// 获取Double
        /// </summary>
        /// <param name="jObject"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static double GetDouble(this JObject jObject, string key)
        {
            double.TryParse(jObject[key] == null ? "" : jObject[key].ToString(), out double result);
            return result;
        }

        /// <summary>
        /// 获取Bool
        /// </summary>
        /// <param name="jObject"></param>
        /// <param name="key"></param>
        /// <returns></returns>
        public static bool GetBoolValue(this JObject jObject, string key)
        {
            bool.TryParse(jObject[key] == null ? "false" : jObject[key].ToString(), out bool result);
            return result;
        }

        /// <summary>
        /// 序列化
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static string Serialize(this object obj)
        {
            IsoDateTimeConverter timeFormat = new IsoDateTimeConverter
            {
                DateTimeFormat = "yyyy-MM-dd HH:mm:ss"
            };
            return Newtonsoft.Json.JsonConvert.SerializeObject(obj, Newtonsoft.Json.Formatting.Indented, timeFormat);
        }

        /// <summary>
        /// 反序列化
        /// </summary>
        /// <typeparam name="T">类型</typeparam>
        /// <param name="value">值</param>
        /// <returns>T</returns>
        public static T DeserializeObject<T>(this string value) where T : class
        {
            return Newtonsoft.Json.JsonConvert.DeserializeObject<T>(value);
        }

        #region Json 字符串 转换为 DataTable数据集合
        /// <summary>
        /// Json 字符串 转换为 DataTable数据集合
        /// </summary>
        /// <param name="json"></param>
        /// <returns></returns>
        public static DataTable ToDataTable(string json)
        {
            DataTable dataTable = new DataTable();  //实例化
            DataTable result;
            try
            {
                ArrayList arrayList = JsonConvert.DeserializeObject<ArrayList>(json);
                if (arrayList.Count > 0)
                {
                    foreach (Dictionary<string, object> dictionary in arrayList)
                    {
                        if (dictionary.Keys.Count<string>() == 0)
                        {
                            result = dataTable;
                            return result;
                        }
                        if (dataTable.Columns.Count == 0)
                        {
                            foreach (string current in dictionary.Keys)
                            {
                                var obj = dictionary[current];
                                dataTable.Columns.Add(current, typeof(string) /*obj == null ? typeof(string) : obj.GetType()*/);//全当做字符串处理
                            }
                        }
                        DataRow dataRow = dataTable.NewRow();
                        foreach (string current in dictionary.Keys)
                        {
                            dataRow[current] = dictionary[current];
                        }

                        dataTable.Rows.Add(dataRow); //循环添加行到DataTable中
                    }
                }
            }
            catch
            {
            }
            result = dataTable;
            return result;
        }
        #endregion

        /// <summary>
        /// 对象命名小驼峰式转换
        /// </summary>
        /// <param name="data"></param>
        public static object GetCamelCaseResultJson(object data)
        {
            if (data == null)
            {
                return null;
            }
            //json对象命名小驼峰式转换
            var json = JsonConvert.SerializeObject(
                data,
                Formatting.Indented,
                new JsonSerializerSettings { ContractResolver = new Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver() }
                );
            return JsonConvert.DeserializeObject(json);
        }
    }
}
