﻿using VT.FW.DB;
using Mall.Common.Enum.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Education
{
    /// <summary>
    ///  教育-资讯管理实体表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Education_Article
    {

        public int ID { get; set; }

        /// <summary>
        /// 商户id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }


        public int Status { get; set; }

        public DateTime CreateDate { get; set; }
        public DateTime UpdateDate { get; set; }


        /// <summary>
        /// 资讯状态   1上架  2下架
        /// </summary>        
        public int? ArticleStatus
        {
            get;
            set;
        }


        /// <summary>
        /// 排序
        /// </summary>        
        public int? Sort
        {
            get;
            set;
        }



        /// <summary>
        /// 自动上架时间
        /// </summary>
        public DateTime? ShelvesDate { get; set; }

        /// <summary>
        /// 自动下架时间
        /// </summary>
        public DateTime? DownDate { get; set; }

        /// <summary>
        /// 虚拟浏览数量
        /// </summary>        
        public int FictitiousBrowseNum
        {
            get;
            set;
        }

        /// <summary>
        /// 浏览数
        /// </summary>        
        public int BrowseNum
        {
            get;
            set;
        }

        /// <summary>
        /// 标题
        /// </summary>

        public string Name { get; set; }

        /// <summary>
        /// 标签
        /// </summary>

        public string LableName { get; set; }


        /// <summary>
        /// 是否可以留言，0-否，1-是
        /// </summary>
        public int IsComment { get; set; }


        /// <summary>
        /// 资讯内容
        /// </summary>
        public string Describe { get; set; }


       
    }
}
