﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Extend.User
{
    /// <summary>
    /// 商户信息表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Tenant_Extend : Model.Entity.User.RB_Tenant
    {
        /// <summary>
        /// 账号有效期
        /// </summary>
        public string AccountValidateStr
        {
            get
            {
                string str = "";
                if (this.IsEffective != null && this.IsEffective == 1)
                {
                    str = "永久有效";
                }
                else
                {
                    if (this.AccountValidate != null)
                    {
                        str = Convert.ToDateTime(this.AccountValidate).ToString("yyyy-MM-dd");
                    }
                }
                return str;
            }
        }

        /// <summary>
        /// 小程序Id【用于登录验证】
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 当前登录员工编号
        /// </summary>
        public int EmpId { get; set; }
    }
}
