﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 菜单仓储层对象
    /// </summary>
    public class RB_MenuRepository : BaseRepository<RB_Menu>
    {
        /// <summary>
        /// 根据查询条件获取菜单列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Menu_Extend> GetListRepository(RB_Menu_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_Menu WHERE 1=1 AND Status=0 ");
            if (query != null)
            {
                if (query.MenuLevel > 0)
                {
                    builder.AppendFormat(" AND MenuLevel={0} ", query.MenuLevel);
                }
                if (query.MenuName != null && !string.IsNullOrEmpty(query.MenuName.Trim()))
                {
                    builder.AppendFormat(" AND MenuName LIKE '%{0}%' ", query.MenuName.Trim());
                }
                if (query.QMenuIds != null && !string.IsNullOrEmpty(query.QMenuIds.Trim()))
                {
                    builder.AppendFormat(" AND MenuId IN({0}) ", query.QMenuIds.Trim());
                }
            }
            return Get<RB_Menu_Extend>(builder.ToString()).ToList();
        }



        /// <summary>
        /// 获取菜单分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Menu_Extend> GetPageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Menu_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_Menu WHERE 1=1 ");
            if (query != null)
            {
                if (query.MenuLevel > 0)
                {
                    builder.AppendFormat(" AND MenuLevel={0} ", query.MenuLevel);
                }
                if (query.MenuName != null && !string.IsNullOrEmpty(query.MenuName.Trim()))
                {
                    builder.AppendFormat(" AND MenuName LIKE '%{0}%' ", query.MenuName.Trim());
                }
            }
            return GetPage<RB_Menu_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }
    }
}
