﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using System.Linq;

namespace Mall.Repository.User
{
    /// <summary>
    /// 商品海报仓储层
    /// </summary>
    public class RB_MiniProgram_GoodPosterRepository : BaseRepository<RB_MiniProgram_GoodPoster>
    {
        /// <summary>
        /// 根据查询条件获取商品海报实体
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public RB_MiniProgram_GoodPoster_Extend GetEntityExtRepository(RB_MiniProgram_GoodPoster_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(" SELECT * FROM RB_MiniProgram_GoodPoster WHERE 1=1 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND TenantId={0} ", query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND MallBaseId={0} ", query.MallBaseId);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND Id={0} ", query.Id);
                }
                if (query.IsOpenSchool >= 0)
                {
                    builder.AppendFormat(" AND IsOpenSchool={0} ", query.IsOpenSchool);
                }
            }
            return Get<RB_MiniProgram_GoodPoster_Extend>(builder.ToString()).FirstOrDefault();
        }
    }
}
