﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.Product
{
    /// <summary>
    /// 商品订单快递信息表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_OrderExpress
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 类型  1快递   2其他方式
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 快递id
        /// </summary>        
        public int? ExpressId
        {
            get;
            set;
        }
        /// <summary>
        /// 邮编
        /// </summary>        
        public string PostCode
        {
            get;
            set;
        }
        /// <summary>
        /// 快递单号
        /// </summary>        
        public string ExpressNumber
        {
            get;
            set;
        }
        /// <summary>
        /// 备注
        /// </summary>        
        public string Remark
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 换货时  售后订单id
        /// </summary>
        public int? AfterSaleOrderId { get; set; }
    }
}
