﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.MarketingCenter;
using VT.FW.DB;

namespace Mall.Model.Entity.MarketingCenter
{
    /// <summary>
    /// 问卷调查基础配置表
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class Rb_Survey
    {

        /// <summary>
        /// 编号
        /// </summary>
        public int ID { get; set; }


        /// <summary>
        /// 活动id
        /// </summary>
        public int ActivitySurveyId { get; set; }

        /// <summary>
        ///意见调查类型
        /// </summary>

        public SurveyTypeEnum? SurveyType { get; set; }


        /// <summary>
        /// 问卷类型
        /// </summary>
        public FormTypeEnum? FormType { get; set; }

        /// <summary>
        /// 标题
        /// </summary>

        public string Title { get; set; }

        /// <summary>
        /// 排序
        /// </summary>
        public int Sort { get; set; }

        /// <summary>
        /// 是否显示（前台）
        /// </summary>
        public int IsShow { get; set; }

        /// <summary>
        /// 删除
        /// </summary>
        public DateStateEnum State { get; set; }

        /// <summary>
        /// 
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// 
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 修改时间
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }

        /// <summary>
        /// 是否必填0-不是，1-是
        /// </summary>
        public int IsRequired { get; set; }

    }
}
